<?php

namespace App\Http\Controllers;

use App\Comments;
use DB;
use Illuminate\Http\Request;
use App\Rules\Captcha;

class CommentsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try
        {
            request()->validate([
              'xyzzy' => 'required',
              'zyxxy' => 'required|email',
              'g-recaptcha-response' => new Captcha()
            ]);

            DB::table('comments')->insert([
            'suggestions_id' => $request['suggestions_id'],
            'message' => $request['formText'],
            'commentor_name' => $request['xyzzy'],
            'commentor_email' => $request['zyxxy'],
            'comments_ip' => $request->ip(),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);

            $suggestions_id = DB::getPdo()->lastInsertId();
               //return redirect()->route('suggestions',['id'=>$suggestions_id]);
                return redirect('suggestions/'.$request['suggestions_id'].'/#comment'.$suggestions_id);

            //return view('suggestions.suggestion')->with('success','Your suggestion was added and is awaiting moderation.');

        }
        catch(\Illuminate\Database\QueryException $e)
        {
            //return View::make('edit.create')->with('status','<strong>'.$siteName.' Site already exist!</strong>'); 
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Comments  $comments
     * @return \Illuminate\Http\Response
     */
    public function show(Comments $comments)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Comments  $comments
     * @return \Illuminate\Http\Response
     */
    public function edit(Comments $comments)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Comments  $comments
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Comments $comments)
    {
        //
    }

    public function toggleupvote(Request $request)
    {
        
        $votes =DB::table('votes')
        ->where('suggestions_id',$request['sid'])
        ->where('vote_ip',$request->ip())
        ->count();
        //dd($votes);
        if($votes == 0)
        {
            DB::table('votes')->insert([
            'suggestions_id' => $request['sid'],
            'vote_ip' => $request->ip(),
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s')
            ]);
        }
        else
        {
                 $total_votes =DB::table('votes')
                ->where('suggestions_id',$request['sid'])
                ->count();

                if($total_votes != 1)
                {
                    $votes =DB::table('votes')
                    ->where('suggestions_id',$request['sid'])
                    ->where('vote_ip',$request->ip())
                    ->delete();
                }
        }

    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Comments  $comments
     * @return \Illuminate\Http\Response
     */
    public function destroy(Comments $comments)
    {
        //
    }
}
