<?php

namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $pageviews = DB::table("pageviews")
        ->select(DB::raw('DATE_FORMAT(created_at, "%Y-%m-%d") as formatted_dob'),DB::raw("SUM(totalvisit) as count"))
        ->orderBy("created_at")
        ->groupBy(DB::raw("date(created_at)"))
        ->get();

        foreach ($pageviews as $result)
        {
            $results_pageviews[] =  [(strtotime($result->formatted_dob) * 1000),$result->count];
        }
        $results_pageviews = json_encode($results_pageviews);
        //$results_pageviews = preg_replace('/"([^"]+)"\s*:\s*/', '$1:', $results_pageviews);
        $results_pageviews = str_replace('"','', (string) $results_pageviews);

         $totalvotes_chart= DB::table("votes")
        ->select(DB::raw('DATE_FORMAT(created_at, "%Y-%m-%d") as formatted_dob'),DB::raw("count(id) as count"))
        ->orderBy("created_at")
        ->groupBy(DB::raw("date(created_at)"))
        ->get();

        foreach ($totalvotes_chart as $result)
        {
            $results_chart_votes[] =  [(strtotime($result->formatted_dob) * 1000),$result->count];
        }
        $results_chart_votes = json_encode($results_chart_votes);
        //$results_pageviews = preg_replace('/"([^"]+)"\s*:\s*/', '$1:', $results_pageviews);
        $results_chart_votes = str_replace('"','', (string) $results_chart_votes);


        $suggestions_total123 = DB::table("suggestions")
        ->select('suggestions.status_id','statuses.name',DB::raw("COUNT(*) as count_row"))
        ->join("statuses","suggestions.status_id","=","statuses.id")
        ->groupBy('suggestions.status_id')
        ->whereNull('suggestions.deleted_at')
        ->orderBy('statuses.seq', 'asc')
        ->get();

        $suggestions_total = DB::table('statuses')
        ->select('suggestions.*','statuses.id','statuses.name')    
        ->leftjoin(DB::raw('(select status_id, count(*) as count_row from suggestions group by status_id) as suggestions'), 
        function($join)
        {
           $join->on('suggestions.status_id', '=', 'statuses.id');
        })
        ->groupBy('statuses.id')
        ->where('statuses.id', '!=' , 1)
        ->orderBy('statuses.seq', 'asc')
        ->get();

        $all_except_done =DB::table('suggestions')
        ->select(DB::raw("COUNT(*) as count_row"))
        ->whereIn("suggestions.status_id", [2,3,4])
        ->whereNull('suggestions.deleted_at')
        ->get();

        $suggestions_all = DB::table("suggestions")->count();
         $total_votes_count_all = DB::table("votes")->count();

            $status_list = DB::table('statuses')->whereNull('deleted_at')->pluck("name","id");
        return view('home',compact('all_except_done','suggestions_total','suggestions_all','status_list','results_pageviews','results_chart_votes','total_votes_count_all'));
    }
}
