<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller as Controller;

use App\Emailtemplates;
use DB;
use Illuminate\Http\Request;

class EmailtemplatesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin/email-templates.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/email-templates.create'); 
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        Emailtemplates::create([
            'title' => $request['title'],
            'content' => $request['content']
        ]);
        return redirect('admin-email-templates')->with('success','Email Templates created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function show(Emailtemplates $ticketemailtemplates)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $ticketemailtemplates = \App\Emailtemplates::find($id);
        return view('admin/email-templates.edit',compact('ticketemailtemplates','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $ticketemailtemplates= \App\Emailtemplates::find($id);
        $ticketemailtemplates->title=$request->get('title');
        $ticketemailtemplates->content=$request->get('content');
        $ticketemailtemplates->save();

        return redirect('admin-email-templates')
            ->with('success','Email Template updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Ticketemailtemplates  $ticketemailtemplates
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
                $ticketemailtemplates = \App\Emailtemplates::find($id)->delete();
        return redirect('admin-email-templates')->with('success','Email Template has been deleted');
    }
}
