<?php

namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller as Controller;

use App\Roles;
use DB;
use Datatables;
use Illuminate\Http\Request;

class RolesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
       //$this->middleware('admin');
    }


    public function index()
    {
        return view('admin/roles.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin/roles.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required|unique:roles|string|max:10',
        ], [
            'name.required' => 'Role is required',
        ]);
        if($request->default_set == 1)
        {
            $affected = DB::table('roles')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        Roles::create($request->all());
        return redirect('admin-roles')->with('success','Role created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function show(Priorities $priorities)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $roles = \App\Roles::find($id);
         $permissionlists = DB::table('permissions')->pluck("name","id");
        return view('admin/roles.edit',compact('roles','id','permissionlists'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required|string|max:10',
        ], [
            'name.required' => 'Role Name is required',
        ]);
        if($request->default_set == 1)
        {
            $affected = DB::table('roles')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        $roles= \App\Roles::find($id);
        $roles->name=$request->get('name');
        $roles->color=$request->get('color');
        $roles->permission_ids=json_encode($request->get('permission_ids'));
        $roles->default_set=$request->get('default_set');
        $roles->save();
        return redirect('admin-roles')->with('success','Role updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $roles = \App\Roles::find($id);
        if($roles->default_set == 0)
        {
            //$priorities->delete();
            $roles = \App\Roles::find($id)->delete();
            return redirect('admin-roles')->with('success','Role has been deleted');
        }
        else{
            return redirect('admin-roles')->with('errors','Do not delete Default Role !');
        }


    }
}
