<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller as Controller;

use App\Users;
use DB;
use Datatables;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class UsersController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        //$this->middleware('admin');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $roles = DB::table('roles')->pluck("name","id");
        return view('admin/users.index',compact('roles'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $roles = DB::table('roles')->whereNull('deleted_at')->get();
        return view('admin/users.create',compact('roles'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        request()->validate([
            'name' => 'required|string',
        ], [
            'name.required' => 'User Name is required',
        ]);

        Users::create([
            'name' => $request['name'],
            'email' => $request['email'],
            'password' => Hash::make($request['password']),
            'role_id' => $request['role_id']
        ]);
        return redirect('admin-users')->with('success','User created successfully.');

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function show(Categories $categories)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $users = \App\Users::find($id);

        $roles = DB::table('roles')->whereNull('deleted_at')->pluck("name","id");
    
        return view('admin/users.edit',compact('users','id','roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $users= \App\Users::find($id);
        $users->name=$request->get('name');
        $users->email=$request->get('email');
        $users->role_id=$request->get('role_id');
        if (($request->get('password')) !== $users->password) {
            $users->password=Hash::make($request->get('password'));
        }
        $users->save();
        // return redirect('categories');
        return redirect('admin-users')
            ->with('success','User updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $users = \App\Users::find($id)->delete();
        //$categories->delete();
        return redirect('users')->with('success','User has been deleted');
    }
}
