@extends('layouts.admin')
@section('title', 'Dashboard')

@section('content')
                <div class="row">
                @if ($message = Session::get('success'))
                    <div class="alert alert-success">
                        <p>{{ $message }}</p>
                    </div>
                @endif
                @if ($message = Session::get('errors'))
                    <div class="alert alert-danger">
                        <p>{{ $message }}</p>
                    </div>
                @endif

                        <h2>Comments
                        </h2>
                </div>
<div class="table-bx">
        <table id="table_suggestions" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Suggestions Title</th>
                    <th>Commentor Name</th>
                    <th>Commentor Email</th>
                    <th>Message</th>
                    <th>Comments IP</th>
                    <th>Last Updated</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
                <tr>
                    <th>ID</th>
                    <th>Suggestions Title</th>
                    <th>Commentor Name</th>
                    <th>Commentor Email</th>
                    <th>Message</th>
                    <th>Comments IP</th>
                    <th>Last Updated</th>
                </tr>
            </tfoot>
        </table>
    </div>


        

@endsection

@section('scripts')
<script>


        $(function() {
           var dtListSuggestion = $('#table_suggestions').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'comments']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'suggestion_title', name: 'suggestion_title' },
                    { data: 'commentor_name', name: 'commentor_name' },
                    { data: 'commentor_email', name: 'commentor_email' },
                    { data: 'message', name: 'message' },
                    { data: 'comments_ip', name: 'comments_ip' },
                    { data: 'updated_at', name: 'updated_at' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });


        });
</script>
@stop