@extends('layouts.admin')
@section('title', 'Create Email Templates')
@section('content')
<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('admin-email-templates.store') }}" accept-charset="UTF-8" id="formapp">
                        @csrf
            <h3>Create New Email Templates</h3>
            <div class="form-group">
                <label>Subject:</label>
                <input class="form-control" name="title" type="text" id="title" placeholder="Email Subject">
                @if ($errors->has('title'))
                    <span class="text-danger">{{ $errors->first('title') }}</span>
                @endif 
            </div>
            <div class="form-group">
                <label>Description:</label>
                <textarea class="ckeditor" name="content" cols="30" id="content" placeholder="Describe your Email here in details"></textarea>
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Save</button>
                <a href="{{ url('admin-email-templates') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>

@endsection
@section('scripts')
<script type="text/javascript" src="{{ asset('ckeditor/ckeditor.js') }}"></script>
<script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
    <script type="text/javascript">
    $(document).ready(function() {

        $("#formapp").validate({
            rules: {
                content: {
                    required: true,
                    minlength: 10
                },
                title: {
                    required: true
                }
            },
            messages: {
                title:{
                    required: "Email Subject is required"
                },
                content: {
                required: "Enter Describe your content here in details",
                    minlength: "Minimum password length is 10"
                }
            },
            errorPlacement: function(error, element) {
                if (element.attr("id") == "content") {
                    //element.parent('div').prev().append(error[0]);
                    $(".contenterror").append(error[0]);
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function(form) {
                form.submit();
            }
        });


        CKEDITOR.on('instanceReady', function () {
        $.each(CKEDITOR.instances, function (instance) {
            CKEDITOR.instances[instance].document.on("keyup", CK_jQ);
            CKEDITOR.instances[instance].document.on("paste", CK_jQ);
            CKEDITOR.instances[instance].document.on("keypress", CK_jQ);
            CKEDITOR.instances[instance].document.on("blur", CK_jQ);
            CKEDITOR.instances[instance].document.on("change", CK_jQ);
        });
        });
        
        function CK_jQ() {
        for (instance in CKEDITOR.instances) {
            CKEDITOR.instances[instance].updateElement();
        }
        }
        
        CKEDITOR.config.toolbar = [
            ['Bold','Italic','Underline','StrikeThrough','-','Undo','Redo','-','Cut','Copy','Paste','Find','Replace','-','Outdent','Indent','-','Print']

        ] ;

    });
    </script>
@stop