@extends('layouts.admin')
@section('title', 'Create Suggestion')
@section('content')
            <div class="page-bx">
                <div class="row">
                   <div class="col-md-12">
                    <h3><i class="fa fa-add"></i> Create New Suggestion</h3>
                    <form method="POST" action="{{ route('admin-suggestions.store') }}?newsuggestion" accept-charset="UTF-8" id="formapp">
                    @csrf
                        <div class="form-group">
                            <label>Title:</label>
                            <input type="text" class="form-control" name="suggestion_title" id="suggestion_title" placeholder="Your suggestion" pattern=".{10,100}" maxlength="100" title="Title must be between 10 and 100 characters." autofocus="">
                            @if ($errors->has('suggestion_title'))
                                <span class="text-danger">{{ $errors->first('suggestion_title') }}</span>
                            @endif   
                        </div>
                        <div class="form-group">
                            <label>Description:</label>
                           <textarea class="form-control" rows="3" name="suggestion_description" id="suggestion_description" placeholder="Description of your suggestion (optional)" maxlength="1000"></textarea>
                        </div>
                        <div class="form-group">
                            <label>Name:</label>
                            <input type="text" class="form-control" name="suggestor_name" id="suggestor_name" placeholder="Your name" maxlength="50">
                            @if ($errors->has('suggestor_name'))
                                <span class="text-danger">{{ $errors->first('suggestor_name') }}</span>
                            @endif
                            <input type="hidden" name="ischeck" value="1" id="ischeck">
                        </div>
                        <div class="form-group">
                            <label>Email:</label>
                            <input type="email" class="form-control" name="suggestor_email" id="suggestor_email" placeholder="Your email" maxlength="100" autocomplete="email">
                            @if ($errors->has('suggestor_email'))
                                <span class="text-danger">{{ $errors->first('suggestor_email') }}</span>
                            @endif
                    <input type="hidden" name="imagePublicId" id="imagePublicId" value="">
                    <input type="hidden" name="imageFormat" id="imageFormat" value="">
                        </div>
                        <div class="form-group">                            
                            <button class="btn" type="submit">Post Suggestion</button>
                            <a href="{{ url('admin-suggestions') }}" class="btn">Back</a>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
@endsection
@section('scripts')
<script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
    <script type="text/javascript">
    $(document).ready(function() {

        $("#formapp").validate({
            rules: {
                suggestion_description: {
                    required: true,
                    minlength: 10
                },
                suggestion_title: {
                    required: true
                },
                suggestor_name: {
                    required: true
                },
                suggestor_email: {
                    required: true
                }
            },
            messages: {
                suggestion_title:{
                    required: "Suggestion Title is required"
                },
                suggestor_name:{
                    required: "Suggestion Name is required"
                },
                suggestor_email:{
                    required: "Suggestion Email is required"
                },
                suggestion_description: {
                required: "Enter Describe your Suggestion here in details",
                    minlength: "Minimum Suggestion length is 10"
                }
            },
            errorPlacement: function(error, element) {
                    error.insertAfter(element);
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });
    </script>
@stop