@extends('layouts.default')
@section('content')
<style>
    .last-nosugg{
        width: 450px !important;
        font-weight: normal;
        top:20px !important;
    }
    .tt-menu{
        width: 450px !important;
        font-weight: normal;
        top:32px !important;
    }
.twitter-typeahead {
    padding-right: 30px;
}

.twitter-typeahead + .glyphicon {
    position: absolute;
    left: 0;
    padding: 13px 10px;
}
 </style>
<h1 class="siteTitle"><span class="hidden-xs">Our customers made these 
        <strong>suggestions for improving Feedback System</strong>.</span>
        <span class="visible-xs-block"><strong>Suggestions for improving Feedback System.</strong></span>
    </h1>

    <div id="controls">
        <div class="pull-right addContainer">
                <a href="{{ route('suggestions.create') }}" class="btn btn-success addNew">
                    <span class="visible-xs">Add</span>
                    <span class="hidden-xs">Add your suggestion</span>
                </a>
        </div>
        <div id="searchContainer" class="pull-right">
            <form method="get" action="/search" id="search-form">
                <input type="text" id="search-input" name="q"
                       placeholder="Search..." title="This field is required!">
                         <span class="glyphicon glyphicon-search"></span>
            </form>
            <div id="hits">
            </div>
        </div>

        <div class="controlBar clearfix">
            <div class="btn-group pull-left orderBy hidden-sm hidden-xs" role="group" aria-label="orderBy">
                <button type="button" id="btn-popular"
                        class="btn btn-default {{ ($order == 'popular') ? 'active' : '' }} orderPopular">
                    <span class="glyphicon glyphicon-star"></span> Top
                </button>
                <button type="button" class="btn btn-default {{ ($order == 'new') ? 'active' : '' }} orderNew"
                        id="btn-new">
                    <span class="glyphicon glyphicon-time"></span> New
                </button>
            </div>
            <div class="btn-group pull-left orderBy visible-sm visible-xs" role="group" aria-label="orderBy">
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                        aria-expanded="false">
                <span
                        class="glyphicon glyphicon-star"></span> {{ ($order == 'popular') ? 'Top' : 'New' }}
                
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="#" id="item-popular"><span
                            class="glyphicon glyphicon-star"></span> Top</a></li>
                    <li><a href="#" id="item-new"><span
                            class="glyphicon glyphicon-time"></span> New</a></li>
                </ul>
            </div>

            <div class="btn-group pull-left filterBy" role="group"
                 aria-label="filterBy">
                <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown"
                        aria-expanded="false">
                {{$aColumns}} ({{$suggestions_list->count()}})
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    <li><a href="#" id="item-all">All ({{$suggestions_all_list_count}})</a>
                    </li>
                    <li role="separator" class="divider"></li>
                    @foreach($status_list as $statusdata)
                    <li><a href="#" id="{{$statusdata->jquery_id}}">{{$statusdata->name}}
                    @if($statusdata->id == 1)
                    ({{$status_list[1]->totalsuggestions + $status_list[2]->totalsuggestions + $status_list[3]->totalsuggestions}})
                     @else
                    ({{$statusdata->totalsuggestions}})
                    @endif
                    </a></li>
                @endforeach
                </ul>
            </div>


            <form action="#controls" id="suggestionsform">
                <input type="hidden" name="order" id="order" value="{{$order}}"/>
                <input type="hidden" name="filter" id="filter" value="{{$filter}}"/>
            </form>

        </div>
    </div>
    <div class="panel suggestionsList" id="suggestionsList">
        @foreach($suggestions_list as $suggestion_data)
        <div id="suggestion{{$suggestion_data->id}}" class="suggestionListItem  ">

                <div class="sNumbers">
                    <a href="{{ route('suggestions.show', ['id'=>$suggestion_data->id]) }}/{{$suggestion_data->suggestion_slug}}" class="sVotes"
                       title="{{$suggestion_data->totalvotes}}">
                    {{$suggestion_data->totalvotes}} <span
                            class="sLabel">votes</span>
                    </a>

                </div>
                    
                <div class="sInfo">
                    <h2 class="sTitle"><a
                            href="{{ route('suggestions.show', ['id'=>$suggestion_data->id]) }}/{{$suggestion_data->suggestion_slug}}">{{$suggestion_data->suggestion_title}}</a>
                    </h2>
                    <div class="sMeta">
                        <span class="sBy">
                            Suggested by: <strong>{{$suggestion_data->suggestor_name}}</strong>
                            ({{ \Carbon\Carbon::parse($suggestion_data->created_at)->format('d M, Y')}})
                        </span>
                             &bull;
                            <span class="sLastComment">
                                Upvoted: {{ \Carbon\Carbon::parse($suggestion_data->upvotedt)->format('d M, Y')}}
                            </span>

                            &bull;
                            <a href="{{ route('suggestions.show', ['id'=>$suggestion_data->id]) }}/{{$suggestion_data->suggestion_slug}}"
                               class="sComments">
                                <span
                                        class="sLabel">Comments: 
                                        @if (!is_null($suggestion_data->totalcomments))
                                            {{$suggestion_data->totalcomments}}
                                        @else
                                            0
                                        @endif
                                    </span>
                            </a>

                    </div>

                    <div class="sLabels">
                        
                    <span class="label {{$suggestion_data->color}}" data-toggle="tooltip" data-placement="bottom" title="{{$suggestion_data->tooltips}}" data-original-title="{{$suggestion_data->tooltips}}">{{$suggestion_data->name}}</span>

                    </div>
                </div>
            </div>
            @endforeach
</div>

    <p class="text-center loadMore">
        <span class="hidden-xs">Looking for more?</span> <a class="mobileBlankButton" href="{{ url('/') }}">
        See the complete list</a>
    </p>


    <div class="addContainer2" style="display: none;">
        <a href="{{ route('suggestions.create') }}" class="btn btn-success addNew">
        Add new
        </a>
    </div>
@stop
@section('scripts')

<script>
    var msie = document.documentMode;
    if (msie < 9) {
        // code for IE < 9
        window.location.href = '/browsernotsupported'
    }

    $(function () {
        // Show / hide secondary add button
        $(document).scroll(function () {
            var target = $('.suggestionsList').offset().top;
            var y = jQuery(this).scrollTop();
            if (y > target) {
                $('.addContainer2').fadeIn();
            } else {
                $('.addContainer2').fadeOut();
            }
        });

        $('#btn-popular, #item-popular').click(function () {
            $('#order').val('popular');
            $('#suggestionsform').submit();
        });

        $('#btn-new, #item-new').click(function () {
            $('#order').val('new');
            $('#suggestionsform').submit();
        });

        $('#item-all').click(function () {
            $('#filter').val('all');
            $('#suggestionsform').submit();
        });

        $('#item-planned').click(function () {
            $('#filter').val('planned');
            $('#suggestionsform').submit();
        });

        $('#item-notplanned').click(function () {
            $('#filter').val('notplanned');
            $('#suggestionsform').submit();
        });
        $('#item-all-except-done').click(function () {
            $('#filter').val('allexceptdone');
            $('#suggestionsform').submit();
        });

        $('#item-underconsideration').click(function () {
            $('#filter').val('underconsideration');
            $('#suggestionsform').submit();
        });

        $('#item-done').click(function () {
            $('#filter').val('done');
            $('#suggestionsform').submit();
        });

        $('#showDeleted').click(function () {
            $('#showDeletedHidden').val(this.checked ? '1' : '0');
            $('#suggestionsform').submit();
        });

        $('#search-form').submit(function() {
            var q = jQuery.trim($('#search-input').val());
            return q.length > 0;
        });
    });
</script>
<script src="https://twitter.github.io/typeahead.js/releases/latest/typeahead.bundle.js"></script>
<script type="text/javascript">
function fn(text, count){
    return text.slice(0, count) + (text.length > count ? "..." : "");
}

        $(document).ready(function() {
            var bloodhound = new Bloodhound({
                datumTokenizer: Bloodhound.tokenizers.whitespace,
                queryTokenizer: Bloodhound.tokenizers.whitespace,
                remote: {
                    url: '{{ url("/suggestionsfind") }}?q=%QUERY%',
                    wildcard: '%QUERY%',
                     _token: '{{csrf_token()}}'
                },
            });
            
            $('#search-input').typeahead({
                hint: true,
                highlight: true,
                minLength: 1
            }, {
                name: 'suggestions',
                source: bloodhound,
                display: function(data) {
                    return data.suggestion_title  //Input value to be set when you select a suggestion. 
                },
                templates: {
                    empty: [
                        '<div class="list-group search-results-dropdown"><div style="font-weight:normal; margin-top:-10px ! important;" class="list-group-item last-nosugg">No suggestions matched your search.</div></div>'
                    ],
                    header: [
                        '<div class="list-group search-results-dropdown">'
                    ],
                    suggestion: function(data) {
                    return '<div style="font-weight:normal; margin-top:-10px ! important;" class="list-group-item"><a href="{{ url('suggestions') }}/' + data.id + '">' + data.suggestion_title + '</a><br/><small>' + fn(data.suggestion_description, 60) + '</small></div></div>'
                    }
                }
            });
        });

</script>

@stop