<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
                <div class="row">
                <?php if($message = Session::get('success')): ?>
                    <div class="alert alert-success">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>
                <?php if($message = Session::get('errors')): ?>
                    <div class="alert alert-danger">
                        <p><?php echo e($message); ?></p>
                    </div>
                <?php endif; ?>

                        <h2>Suggestions
                            <a href="<?php echo e(route('admin-suggestions.create')); ?>" class="btn pull-right"><i class="icon-plus"></i> Add suggestion</a>
                        </h2>
                </div>
<div class="table-bx">
        <div class="filter-bx">
            <div class="row">
                <div class="col-lg-3 col-sm-6">
                    <div class="form-group">
                        <label>Filter By</label>
                        <select id="statusFilter" name="search_group_filter" class="form-control">
                            <option value="0">All Status</option>
                            <?php $__currentLoopData = $status_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <table id="table_suggestions" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
            <tfoot>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Suggestor Name</th>
                    <th>Suggestor Email</th>
                    <th>Votes</th>
                    <th>Suggestor IP</th>
                    <th>Last Updated</th>
                    <th>Status</th>
                </tr>
            </tfoot>
        </table>
    </div>


        

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
var flagstatus = <?php echo e($flagstatus); ?>;

        $(function() {
           var dtListSuggestion = $('#table_suggestions').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('loaddata.index',['action' => 'suggestions'])); ?>'+ '&flagstatus=' + flagstatus,
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'suggestion_title', name: 'suggestion_title' },
                    { data: 'suggestor_name', name: 'suggestor_name' },
                    { data: 'suggestor_email', name: 'suggestor_email' },
                    { data: 'totalvotes', name: 'totalvotes' },
                    { data: 'suggestor_ip', name: 'suggestor_ip' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });


            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
               var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + filter_value;
                dtListSuggestion.ajax.url(new_url).load();

            } );

        });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>