<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use DB;
use Datatables;
class LoadDataController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth',['except' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $action = $request->action;
        switch ($request->action) {
            default:
                return response()->json(['message' => 'Invalid Request']);
                break;
            case "priorities":
                $aColumns = ['created_at', 'default_set', 'name', 'id'];
                $sTable = "priorities";
                break;
            case "roles":
                $aColumns = ['created_at', 'default_set', 'name', 'id'];
                $sTable = "roles";
                break;
            case "categories":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "categories";
                break;
            case "suggestions":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "suggestions";
                break;
            case "subsuggestion":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "suggestions";
                break;
            case "users":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "users";
                break;
            case "userfiltertroles":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "users";
                break;
            case "emailtemplates":
            	$aColumns = ['created_at', 'email', 'name', 'id'];
            	$sTable = "ticketemailtemplates";
            	break;
            case "cannedresponse":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "cannedresponses";
                break;
            case "subcannedresponse":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "cannedresponses";
                break;
            case "configuration":
                $aColumns = ['created_at', 'email', 'name', 'id'];
                $sTable = "configurations";
                break;
            case "subcategories":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "subcategories";
                break;
            case "statuses":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "statuses";
                break;
            case "tickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "usertickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "subfilterusertickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "dashboardtickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "dashboardsubfiltertickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "dashboardactivetickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "dashboardsubactivefiltertickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;
            case "subfiltertickets":
                $aColumns = ['created_at', 'name', 'cname', 'id'];
                $sTable = "tickets";
                break;


        }



        $table = DB::table($sTable);

        //mysql Join, select where all condition

        if ($action == 'subcategories') {
            $table->join('categories', 'subcategories.category_id', '=', 'categories.id');
            $table->select('subcategories.*', 'categories.name AS cname');
            $table->whereNull('subcategories.deleted_at');
                if($request->status && $request->status != 0) {
                    $table->where("subcategories.category_id", "=", $request->status);
                }
            $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'priorities') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'roles') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'categories') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }
        if ($action == 'suggestions') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }
        if ($action == 'subsuggestion') {
            $table->join('categories', 'suggestions.category_id', '=', 'categories.id');
            $table->select('suggestions.*', 'categories.name AS cname');
            $table->whereNull('suggestions.deleted_at');
                if($request->status && $request->status != 0) {
                    $table->where("suggestions.category_id", "=", $request->status);
                }
            $table->orderBy('suggestions.updated_at', 'desc');
        }
        
        if ($action == 'emailtemplates') {
             $table->whereNull('deleted_at');
             $table->orderBy('updated_at', 'desc');
        }
        
        if ($action == 'cannedresponse') {
             $table->whereNull('deleted_at');
             $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'subcannedresponse') {

             $table->whereNull('deleted_at');
                if($request->status && $request->status != 0) {
                    $table->where("cannedresponses.category_id", "like", "%".$request->status."%");
                }
             $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'users') {
            $table->join('roles', 'users.role_id', '=', 'roles.id');
            $table->select('users.*', 'roles.name AS rname','roles.color AS rcolor');
            $table->whereNull('users.deleted_at');
            $table->orderBy('users.updated_at', 'desc');
        }

        if ($action == 'userfiltertroles') {
            $table->join('roles', 'users.role_id', '=', 'roles.id');
            $table->select('users.*', 'roles.name AS rname','roles.color AS rcolor');
            $table->whereNull('users.deleted_at');
            if($request->status && $request->status != 0) {
                $table->where("users.role_id", "=", $request->status);
            }
            $table->orderBy('users.updated_at', 'desc');
        }


        if ($action == 'statuses') {
            $table->whereNull('deleted_at');
            $table->orderBy('updated_at', 'desc');
        }

        if ($action == 'tickets') {
            $table->join('priorities', 'tickets.priority_id', '=', 'priorities.id');
            $table->join('categories', 'tickets.category_id', '=', 'categories.id');
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'priorities.name AS pname', 'categories.name AS cname','categories.shortname AS shortname', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor', 'priorities.color as pcolor');
            $table->whereNull('tickets.deleted_at');
            if($request->flagstatus != 5) {
                $table->where("tickets.ticketable_type", "=", $request->flagstatus);
            }
            if ($request->catid && $request->catid == 2) {
                $table ->whereIn("tickets.status_id", [2]);
            } else {
                $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            }
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc');
        }

        if ($action == 'subfiltertickets') {
            $table->join('priorities', 'tickets.priority_id', '=', 'priorities.id');
            $table->join('categories', 'tickets.category_id', '=', 'categories.id');
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'priorities.name AS pname', 'categories.name AS cname','categories.shortname AS shortname', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor', 'priorities.color as pcolor');
            $table->whereNull('tickets.deleted_at');
            if($request->status && $request->status != 0) {
                $table->where("tickets.category_id", "=", $request->status);
            }
            if($request->pstatus && $request->pstatus != 0) {
                $table->where("tickets.status_id", "=", $request->pstatus);
            }
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc');
        }

        if ($action == 'usertickets') {
            $table->join('priorities', 'tickets.priority_id', '=', 'priorities.id');
            $table->join('categories', 'tickets.category_id', '=', 'categories.id');
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'priorities.name AS pname', 'categories.name AS cname', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor', 'priorities.color as pcolor');
            $table->whereNull('tickets.deleted_at');
            if ($request->catid && $request->catid == 2) {
                $table ->whereIn("tickets.status_id", [2]);
            } else {
                $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            }
            $table->where("tickets.domain_name", "=", $request->domainame);
            $table->orderBy('tickets.id', 'desc');
        }

        if ($action == 'subfilterusertickets') {
            $table->join('priorities', 'tickets.priority_id', '=', 'priorities.id');
            $table->join('categories', 'tickets.category_id', '=', 'categories.id');
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'priorities.name AS pname', 'categories.name AS cname', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor', 'priorities.color as pcolor');
            $table->whereNull('tickets.deleted_at');
            if ($request->catid && $request->catid == 2) {
                $table ->whereIn("tickets.status_id", [2]);
            } else {
                $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            }
            if($request->status && $request->status != 0) {
                $table->where("tickets.category_id", "=", $request->status);
            }
            $table->where("tickets.domain_name", "=", $request->domainame);
            $table->orderBy('tickets.id', 'desc');
        }

        if ($action == 'dashboardtickets') {
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor');
            $table->whereNull('tickets.deleted_at');
            //$table ->whereIn("tickets.status_id", [1,3]);
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc')->take(10);
        }

        if ($action == 'dashboardsubfiltertickets') {
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor');
            $table->whereNull('tickets.deleted_at');
            if($request->status && $request->status != 0) {
                $table->where("tickets.category_id", "=", $request->status);
            }
            $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc')->take(10);
        }

        if ($action == 'dashboardactivetickets') {
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor');
            $table->whereNull('tickets.deleted_at');
            $table->where("tickets.ticketable_type", "=", 1);
            $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc')->take(10);
        }

        if ($action == 'dashboardsubactivefiltertickets') {
            $table->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id');
            $table->join('statuses', 'tickets.status_id', '=', 'statuses.id');
            $table->select('tickets.*', 'subcategories.name as subname', 'statuses.name as sname', 'statuses.color as scolor');
            $table->whereNull('tickets.deleted_at');
            $table->where("tickets.ticketable_type", "=", 1);
            if($request->status && $request->status != 0) {
                $table->where("tickets.category_id", "=", $request->status);
            }
            $table ->whereIn("tickets.status_id", [1,3,4,5,6]);
            if(Auth::user()) {
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $table ->whereIn("tickets.category_id", array_flatten($all_assign_app));
            }
            $table->orderBy('tickets.id', 'desc')->take(10);
        }

        // finally get data from table
        $table = $table->get();


        if ($action == 'priorities') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'priorities.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'priorities.edit\', $id) }}" class="btn btn-sm btn-raised btn-info" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-sm btn-raised btn-danger" onclick="return confirm(\'Are you sure you want to delete the Priority: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('name', '<span style="color: {{$color}}">{{$name}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->editColumn('default_set', '{{ $default_set == \'0\' ? \' - \' : \'Default\' }}')
                ->escapeColumns([])
                ->toJson();
        }
        if ($action == 'roles') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'roles.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'roles.edit\', $id) }}" class="btn btn-sm btn-raised btn-info" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-sm btn-raised btn-danger" onclick="return confirm(\'Are you sure you want to delete the Role: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('name', '<span style="color: {{$color}}">{{$name}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->editColumn('default_set', '{{ $default_set == \'0\' ? \' - \' : \'Default\' }}')
                ->escapeColumns([])
                ->toJson();
        }


        if ($action == 'categories') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'categories.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'categories.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the App: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                 ->editColumn('shortname', function ($table) {
                    if (empty($table->shortname)) {
                        return "-";
                    }else{
                        return "$table->shortname";
                    }
                })
            
                            ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'suggestions' || $action =='subsuggestion') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'suggestions.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'suggestions.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Suggestion: {{$title}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                    ->editColumn('keywords', function ($table) {
                        if (empty($table->keywords)) {
                            return "-";
                        }else{
                            $keywords = explode(',', $table->keywords);
                            $allKeywords = array();
                            foreach ($keywords as $keyword) {
                              $keywords =  "<td><span class='badge badge-pill badge-info'>".$keyword."</span></td>";
                              array_push($allKeywords,$keywords);
                            }
                    
                            return implode(" " ,$allKeywords);
                        }
                    })
                ->editColumn('title', '<span title="{{ $title }}">{{ str_limit( $title ,25) }}</span>')   
                ->editColumn('destination_url', function ($table) {
                	$urlparts = parse_url($table->destination_url);
                 return '<a href="'.$table->destination_url.'" title="'.$table->destination_url.'" target="_blank"> '.str_limit($urlparts['path'], 65) .' </a>';
                })   
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'users' || $action =='userfiltertroles') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'users.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'users.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the User: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('email', function ($table) {
                    if (empty($table->email)) {
                        return "-";
                    }else{
                        return "$table->email";
                    }
                })
                ->editColumn('rname', '<span style="color: {{$rcolor}}">{{$rname}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
        
        if ($action == 'emailtemplates') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'ticket-email-templates.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'ticket-email-templates.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Email Templates: {{$title}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
        
        if ($action == 'cannedresponse' || $action == 'subcannedresponse') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'canned-response.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'canned-response.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Canned response: {{$title}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'configuration') {
            return Datatables::of($table)
                ->addColumn('action','<a href="{{ route(\'configuration.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'subcategories') {

            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'subcategories.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'subcategories.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Category: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
        if ($action == 'statuses') {
            return Datatables::of($table)
                ->addColumn('action','
                <form action="{{ route(\'statuses.destroy\', $id) }}" method="POST">
                <a href="{{ route(\'statuses.edit\', $id) }}" class="btn btn-info btn-sm btn-raised" ><i class="fa fa-edit
"></i></a>
                <input type="hidden" name="_method" value="DELETE">
                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                <button type="submit" class="btn btn-danger btn-sm btn-raised" onclick="return confirm(\'Are you sure you want to delete the Status: {{$name}}?\')" value="DELETE!"><i class="fa fa-trash
"></i></button>
                </form>')
                ->editColumn('name', '<span style="color: {{$color}}">{{$name}}</span>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->editColumn('default_set', '{{ $default_set == \'0\' ? \' - \' : \'Default\' }}')
                ->escapeColumns([])
                ->toJson();
        }
        if ($action == 'tickets' || $action == 'usertickets' || $action == "subfiltertickets" || $action == 'subfilterusertickets') {
            return DataTables::of($table)
                //->editColumn('id', '<button class="btn btn-work" style="background-color: {{ $ticketable_type == \'0\' ? \' #FF0000 \' : \'#FFB900\' }}">&#x4F;</button>#{{$id}} ')
                ->editColumn('id', function ($table) {
                    if ($table->ticketable_type === 0) {
                        return "<span title=\"New\" style=\"color:#FF0000\"><i class=\"fa fa-folder\"></i></span> #$table->id-$table->shortname";
                    }else{
                        return "<span title=\"Open\" style=\"color:#FFB900\"><i class=\"fa fa-folder-open\"></i></span> #$table->id-$table->shortname";
                    }
                })
                ->editColumn('sname', '<span style="color: {{$scolor}}">{{$sname}}</span>')
                ->editColumn('pname', '<span style="color: {{$pcolor}}">{{$pname}}</span>')
                ->editColumn('subject', '<a href="{{ route(\'tickets.show\', $id) }}">{{ str_limit( $subject ,40) }}</a>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }

        if ($action == 'dashboardtickets' || $action == 'dashboardactivetickets' || $action == 'dashboardsubfiltertickets' || $action == 'dashboardsubactivefiltertickets') {
            return DataTables::of($table)
                //->editColumn('id', '<button class="btn btn-work" style="background-color: {{ $ticketable_type == \'0\' ? \' #FF0000 \' : \'#FFB900\' }}">&#x4F;</button>#{{$id}} ')
                ->editColumn('id', function ($table) {
                    if ($table->ticketable_type === 0) {
                        return "<button class=\"btn btn-work\" title=\"New\" style=\"background-color:#FF0000\">&#x4E;</button>";
                    }else{
                        return "<button class=\"btn btn-work\" title=\"Open\" style=\"background-color:#FFB900\">&#x4F;</button>";
                    }
                })
                ->editColumn('ticket_id', '#{{$id}}')
                ->editColumn('sname', '<span style="color: {{$scolor}}">{{$sname}}</span>')
                ->editColumn('subject', '<a href="{{ route(\'tickets.show\', $id) }}">{{ str_limit( $subject ,50) }}</a>')
                ->editColumn('updated_at', '<time title="{{$updated_at}}">{{ Carbon\Carbon::parse($updated_at)->diffForHumans()}}</time>')
                ->escapeColumns([])
                ->toJson();
        }
    }

}
