<?php

namespace App\Http\Controllers;

use App\Suggestions;
use DB;
use Illuminate\Http\Request;

class SuggestionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        return view('suggestions.index',compact('category'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        return view('suggestions.create',compact('category'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'title' => 'required|min:10|unique:suggestions,title',
            'destination_url' => 'required|unique:suggestions,destination_url',
            'keywords' => 'required',
            'category_id' => 'required'
        ], [
            'name.required' => 'The Title field is required.',
            'destination_url.required' => 'Destination URL is required',
            'keywords.required' => 'Keywords are required',
            'category_id.required' => 'The App field is required.'
        ]);
        $suggestions = Suggestions::create($request->all());


        return redirect('suggestions')
            ->with('success','Suggestion created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function show(Suggestions $suggestions)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $suggestions = \App\Suggestions::find($id);

        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        //$table->whereNull('deleted_at');
        return view('suggestions.edit',compact('suggestions','id', 'category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, $id)
    {
        request()->validate([
            'title' => 'required|min:10',
            'destination_url' => 'required',
            'keywords' => 'required'
        ], [
            'name.required' => 'Suggestion Title is required',
            'destination_url.required' => 'Destination URL is required',
            'keywords.required' => 'Keywords are required'
        ]);
        $suggestions= \App\Suggestions::find($id);
        $suggestions->title=$request->get('title');
        $suggestions->destination_url=$request->get('destination_url');
        $suggestions->keywords=$request->get('keywords');
        $suggestions->category_id=$request->get('category_id');
        $suggestions->save();

        return redirect('suggestions')
            ->with('success','Suggestion updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Suggestions  $suggestions
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $suggestions = \App\Suggestions::find($id)->delete();
        return redirect('suggestions')->with('success','Suggestion has been deleted');
    }
}
