@extends('layouts.default')
@section('title', 'Create Priority')
@section('content')


<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
         <form id="edit-profile" method="POST" action="{{ route('priorities.store') }}" accept-charset="UTF-8">
             @csrf
            <h3>Create New Priority:</h3>
            <div class="form-group">
                <label>Name:</label>
                <input type="text" class="form-control  " name="name" id="name" placeholder="Priority">
                @if ($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Color:</label>
                <input id="simple-color-picker" type="text" name="color" class="form-control" value="#8f3596"/>
            </div>
            <div class="form-group">
                <div class="check-bx">
                    <label>
                        <input type="checkbox" name="default_set" value="1" id="ischeck">
                        <span></span>
                        Default Priority
                    </label>
                </div>
            </div>
             <div class="form-group">
                <button class="btn" type="submit">Save</button>
                <a href="{{ url('/priorities') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>

$('#simple-color-picker').minicolors({
    control: $(this).attr('data-control') || 'hue',
    position: $(this).attr('data-position') || 'bottom left',

    change: function(value, opacity) {
        if (!value) return;
        if (opacity) value += ', ' + opacity;
        if (typeof console === 'object') {
            console.log(value);
        }
    },
    theme: 'bootstrap'
});
</script>
@stop