@extends('layouts.default')
@section('title', 'Create Suggestion')
@section('content')

    <div class="page-bx">
        <div class="row">
            <div class="col-md-12">
              <h3>Create New Suggestion</h3>
              <form method="POST" action="{{ route('suggestions.store') }}" accept-charset="UTF-8" id="formapp">
                @csrf

                <div class="form-group">
                    <label>App:</label>
                    <select name="category_id" class="form-control">
                        <option value="">Select App</option>
                        @foreach ($category as $cat => $value)
                            <option value="{{ $cat }}"> {{ $value }}</option>
                        @endforeach
                    </select>
                    @if ($errors->has('category_id'))
                        <span class="text-danger">{{ $errors->first('category_id') }}</span>
                    @endif
                </div>
                <div class="form-group">
                    <label>Title:</label>
                    <input class="form-control" name="title" type="text" id="title" placeholder="Suggestion Title">
                    @if ($errors->has('title'))
                        <span class="text-danger">{{ $errors->first('title') }}</span>
                    @endif  
                </div>
                <div class="form-group">
                    <label>Destination Url:</label>
                    <input class="form-control" name="destination_url" type="text" id="destination_url" placeholder="Destination Url">
                    @if ($errors->has('destination_url'))
                        <span class="text-danger">{{ $errors->first('destination_url') }}</span>
                    @endif
                </div>
                <div class="form-group">
                    <label>Keywords:</label>
                    <input class="form-control" data-role="tagsinput" name="keywords" type="text" id="keywords" placeholder="Enter Your keywords">
                    @if ($errors->has('keywords'))
                        <span class="text-danger">{{ $errors->first('keywords') }}</span>
                    @endif
                </div>
                <div class="form-group">
                    <button class="btn" type="submit">Save</button>
                    <a href="{{ url('suggestions') }}" class="btn">Back</a>
                </div>

              </form>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js"></script>
<script>

    //Form Validation
    $().ready(function() {
        $(".bootstrap-tagsinput input").addClass("form-control");
        $("#formapp").validate({
            ignore: [],
            rules : {
                title : {
                    required : true,
                    minlength: 10
                },
                destination_url : {
                    required: true
                },
                keywords : {
                    required: true
                },
                category_id : {
                    required: true
                }
            },
            messages: {
                title: {
                    required:"The Title field is required.",
                    minlength: "Your title must be at least 10 characters long"
                },
                destination_url: "The Destination URL is required.",
                keywords: "The keywords field is required.",
                category_id: "The App field is required."
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });
</script>
@stop