@extends('layouts.default')
@section('title', 'Edit Suggestion')
@section('content')

<div class="page-bx">
    <div class="row">
        <div class="col-md-12">
        <form method="POST" action="{{ route('suggestions.update',$suggestions->id) }}" accept-charset="UTF-8" class="form-horizontal">
            @csrf
            @method('PUT')
            <h3>Edit Suggestion : {{ $suggestions->title }}</h3>
            <div class="form-group">
                <label>App:</label>
                <select name="category_id" class="form-control">
                    <option value="">Select App</option>
                @foreach ($category as $cat => $value)
                        <option value="{{ $cat }}" @if($cat == $suggestions->category_id) selected @endif >{{ $value }}</option>

                    @endforeach
                </select>
                @if ($errors->has('category_id'))
                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Title:</label>
                <input class="form-control" name="title" type="text" id="title" value="{{ $suggestions->title }}" placeholder="Suggestion Title">
                @if ($errors->has('title'))
                    <span class="text-danger">{{ $errors->first('title') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Destination Url:</label>
                <input class="form-control" name="destination_url" type="text" id="destination_url" value="{{ $suggestions->destination_url }}" placeholder="Destination Url">
                @if ($errors->has('destination_url'))
                    <span class="text-danger">{{ $errors->first('destination_url') }}</span>
                @endif
            </div>
            <div class="form-group">
                <label>Keywords:</label>
                <input class="form-control" data-role="tagsinput" name="keywords" type="text" id="keywords" value="{{ $suggestions->keywords }}" placeholder="Enter Your keywords">
                @if ($errors->has('keywords'))
                    <span class="text-danger">{{ $errors->first('keywords') }}</span>
                @endif
            </div>
            <div class="form-group">                            
                <button class="btn" type="submit">Update</button>
                <a href="{{ url('suggestions') }}" class="btn">Back</a>
            </div>
        </form>
        </div>
    </div>
</div>
@endsection
@section('scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js"></script>
<script type="text/javascript">
 $().ready(function() {
$(".bootstrap-tagsinput input").addClass("form-control");
});
</script>
@stop