@extends('layouts.default')
@section('title', 'Suggestions')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif

            <h2>Suggestions Management
                <a href="{{ route('suggestions.create') }}" class="btn pull-right"><i class="icon-plus"></i> Create new Suggestion</a>
            </h2>
    </div>
                <div class="table-bx">
                            <div class="filter-bx">
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="form-group">
                                            <label>Filter By App</label>
                                            <select id="statusFilter" name="search_group_filter" id="statusFilter" class="form-control">
                                                <option value="0">All Apps</option>
                                                @foreach ($category as $cat => $value)
                                                    <option value="{{ $cat }}"> {{ $value }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Destination URL</th>
                            <th>Keywords</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Destination URL</th>
                            <th>Keywords</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
@endsection
@section('scripts')
    <script>
        $(function() {
           var dtListSuggestion = $('#table_tickets').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'suggestions']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'title', name: 'title' },
                    { data: 'destination_url', name: 'destination_url' },
                    { data: 'keywords', name: 'keywords' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });


            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
               var new_url = '{{ url('loaddata') }}?action=subsuggestion&status=' + filter_value;
                dtListSuggestion.ajax.url(new_url).load();

            } );

        });
    </script>
@stop