@extends('layouts.default')
@section('title', 'Suggestion - Trackings')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif
  </div>
   

      <div class="page-bx">
        <div class="row">
          <div class="col-lg-6">
            <h3>Suggestions Tracking</h3>
            <div class="table-bx">
                        <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th> No. </th>
                            <th> Keywords </th>
                            <th> View </th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($suggestions_top_keywords as $indexKey => $p)
                        <tr>
                        <td>{{ $indexKey+1 }}</td>
                        <td><span class="badge badge-pill badge-info">{{$p->keywords}}</span></td>
                        <td><span class="badge badge-pill badge-info">{{$p->total_count}}</span></td>
                        </tr>
                        @endforeach

                        @if($suggestions_top_keywords->isEmpty())
                        <tr><td colspan="3" style="text-align: center;"><b>No Records found</b></td></tr>
                        @endif
                        </tbody>
                        <tfoot>
                            <tr>
                            <th> No. </th>
                            <th> Keywords </th>
                            <th> View </th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
          </div>
          <div class="col-lg-6">
            <h3>Top DocUrls List</h3>
            <div class="table-bx">
                        <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th> No. </th>
                            <th> Destination URL </th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($suggestions_top_doc_urls as $indexKey => $p)
                        <tr>
                        <td>{{ $indexKey+1 }}</td>
                        <td><a href="{{$p->destination_url}}" target="_blank">{{$p->destination_url}}</a></td>
                        </tr>
                        @endforeach
                        @if($suggestions_top_doc_urls->isEmpty())
                        <tr><td colspan="2" style="text-align: center;"><b>No Records found</b></td></tr>
                        @endif
                        </tbody>
                        <tfoot>
                            <tr>
                            <th> No. </th>
                            <th> Destination URL </th>
                            </tr>
                        </tfoot>
                    </table>
              </div>
          </div>
        </div>
      </div>
@endsection
