@extends('layouts.default')
@section('title', 'Tickets')
@section('content')
<style>
.admincomments{background: #00ba8b !important; color:#fff;}
p{font-size:15px; margin-bottom: 20px;}
/* datatable height decrese*/
.table.dataTable tbody td {padding-bottom: 3px !important; padding-top: 2px !important;}
.table th, .table td{padding-bottom: 0px !important;}

.text-danger{color: red;}

/* table action button css*/
.action-table .btn-small {padding: 4px; font-size: 14px;}
.asterisk::after {content: "*"; color:red;}

/* jquery form validation errors */
.error{color: red;}

/* comments images avatar */
figure {display:inline-block; margin:10px; max-width:100px; vertical-align:top;}
figure img {display:block; margin:0 auto;}
figcaption {display:block; padding:5px; text-align: center; max-width: 70px;}
.bootstrap-tagsinput {width: 560px;}
.customefilter, .customeprioritiyfilter { width:300px; float:right;}
.dataTables_wrapper .dataTables_filter {text-align: left !important;}
#table_filter input {margin: 0;}
.multiselect, .multiselect-container {width: 100% !important;}
.cke_combo__strinsert, .cke_combo_button, .cke_combo_label {width: 150px !important;}
.cke_combo_text, .cke_combo_open {width: 115px !important;}

/*dropzone*/



.attach-img-tag {border: 1px solid #ddd;  border-radius: 4px; padding: 5px; margin-top:10px;height: 120px; width: 120px;}
/* Add a hover effect (blue shadow) */
.attach-img-tag:hover {box-shadow: 0 0 2px 1px rgba(0, 140, 186, 0.5);}
.thumbnail-attach .caption {padding: 5px; text-align:center;}
.dropzone .dz-message {  margin: 0 !important;}
.dropzone {  min-height: inherit !important;}

/* Lightbox */
#close-lightbox {position: fixed; top: 20px; right: 20px; font-size: 40px; color: #FFF; cursor: pointer}
#lightbox-image {position: fixed; top: 50%; left: 50%; margin: 0; max-width: 100%; -webkit-transform: translate(-50%, -50%); -moz-transform: translate(-50%, -50%);
    -ms-transform: translate(-50%, -50%); transform: translate(-50%, -50%)}
#lightbox-image-wrapper {width: auto; max-width: 100%; max-height: 100%; margin: 0 auto}
#lightbox-wrapper {display: none; width: 100%; height: 100%; background: rgba(0, 0, 0, .8); position: fixed; top: 0; left: 0; z-index: 99999}
#lightbox-wrapper.active {display: block}
.smp-lightbox {cursor: pointer; cursor: -moz-zoom-in; cursor: -webkit-zoom-in; cursor: zoom-in}
.status-notification{padding: 4px; border-radius: 4px; text-align:right;}

/* Message layout */
ul.messages_layout {position: relative; margin: 0; padding: 0}
ul.messages_layout li {list-style: none; position: relative}
ul.messages_layout li.left {padding-left: 100px}
ul.messages_layout li.right {padding-right: 100px}
ul.messages_layout li.right .avatar {right: 0; left: auto}
ul.messages_layout li.right .message_wrap .arrow {right: -12px; left: auto; background-position: 0 -213px; height: 15px; width: 12px}
ul.messages_layout li.by_myself .message_wrap {border: 1px solid #b3cdf8}
ul.messages_layout li.by_myself .message_wrap .info a.name {color: #4a8cf7}
ul.messages_layout li a.avatar {position: absolute; left: 0; top: 0; padding: 5px}
ul.messages_layout li a.avatar img {-webkit-border-radius: 5px; -moz-border-radius: 5px; border-radius: 5px}
ul.messages_layout li .message_wrap {-webkit-border-radius: 3px; -moz-border-radius: 3px; border-radius: 3px; position: relative; border: 1px solid #e9e9e9;    padding: 10px; border: 1px solid #cbcbcb; margin-bottom: 20px; background: #fefefe; -webkit-box-shadow: rgba(0,0,0,0.1) 0 1px 0px; -moz-box-shadow: rgba(0,0,0,0.1) 0 1px 0px; box-shadow: rgba(0,0,0,0.1) 0 1px 0px}
ul.messages_layout li .message_wrap .arrow {background-position: 0 -228px; height: 15px; width: 12px; height: 15px; width: 12px; position: absolute; left: -12px;
    top: 13px}
ul.messages_layout li .message_wrap .info {width: 100%; text-align: right; line-height: 23px;}
ul.messages_layout li .message_wrap .info .name {float: left; font-weight: bold; color: #483734}
ul.messages_layout li .message_wrap .info .time {font-size: 11px; margin-left: 6px}
ul.messages_layout li .message_wrap .text {width: 100%; border-bottom: 1px solid #cfcfcf; padding-bottom: 5px}
ul.messages_layout .dropdown-menu  li{ width:100%; font-size:11px;}

.rail {position: fixed;top: 10%;right: 2.5%; transition: transform 0.3s ease-in-out 0s, margin 0.3s ease-in-out 0s;animation-duration: 0.2s; }
.allcomments{ transform 0.3s ease-in-out 0s, margin 0.3s ease-in-out 0s;animation-duration: 0.2s; }
.imgpicattach{display: inline-block;width: auto;}

.droparrow{
-webkit-appearance: menulist-button;
}

</style>

            <div class="row">
                @if ($message = Session::get('success'))
                    <div class="alert alert-success">
                        <p>{{ $message }}</p>
                    </div>
                @endif
                    <h2>#{{$tickets[0]->id}}-{{$tickets[0]->shortname}}  :  {{$tickets[0]->subject}}
                        <a href="{!! str_replace('support/', '', $tickets[0]->base_url) !!}shop_index.php?domain={{ $shopdetails[0]->shop_domain }}&secret={{ $shopdetails[0]->shop_secret }}" target="_blank" class="btn pull-right">Login to Shop</a></h2>
                    </h2>
            </div>
            <div class="page-bx">
                <div class="main-tops-part"></div>
                <div class="ticket-sidebar item-container">
                    <div class="row">
                        <div class="ticket-point col-lg-6 col-sm-6">
                               <h3 style="display:none;" class="login_to_shop">#{{$tickets[0]->id}}-{{$tickets[0]->shortname}}  :  {{$tickets[0]->subject}}</h3>
                                <ul>
                                    <li><strong>App</strong>: {{$tickets[0]->cname}}</li>
                                    <li><strong>Status</strong>:
                                        <label class="name" style="display:inline-block;"><span style="color: {{$tickets[0]->scolor}}">{{$tickets[0]->sname}}</span> &nbsp;</label>
                                        <select name="sp_main_status" id='sp_main_status' class='com_text' style="display: none;">
                                            @foreach ($statuses as $status)
                                                <option value="{{ $status->name }}" data-id="{{$status->id}}"> {{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                         <select id="time_main_durations" name="time_main_durations" style="display: none;">
                                             <option value="0" data-id="0">Select Duration</option>
                                                @foreach ($time_durations as $durations)
                                                    <option value="{{ $durations->id }}" data-id="{{$durations->id}}"> {{ $durations->name }}</option>
                                                @endforeach
                                        </select>
                                        <a href="javascript:void(0)" class="edit" style="color:#21a9ec;font-size: 17px;"><span class="fa fa-pencil"></span></a>
                                        <a href="javascript:void(0)" class="save" style="display: none;font-size: 20px;"><span class="fa fas fa-check"></span></a>
                                        <a href="javascript:void(0)" class="cancel" style="display: none;color:#bd2b1f;font-size: 20px;"><span class="fa fa-remove"></span></a>
                                    <span id="loading_status" style="display:none;"><img src="{{asset('images')}}/loading.gif" height="30" width="80" /></span>
                                    </li>
                                    <li><strong>Priority</strong>:
                                        <label class="pname" style="display:inline-block;"><span style="color: {{$tickets[0]->pcolor}}">{{$tickets[0]->pname}}</span> &nbsp;</label>
                                        <select id='text_2' class='pcom_text' style="display: none;">
                                            @foreach ($priority as $prty)
                                                <option value="{{ $prty->name }}" data-id="{{$prty->id}}"> {{ $prty->name }}</option>
                                            @endforeach
                                        </select>
                                        <a href="javascript:void(0)" class="pedit" style="color:#21a9ec;font-size: 17px;"><span class="fa fa-pencil"></span></a>
                                        <a href="javascript:void(0)" class="psave" style="display: none;font-size: 20px;"><span class="fa fas fa-check"></span></a>
                                        <a href="javascript:void(0)" class="pcancel" style="display: none;color:#bd2b1f;font-size: 20px;"><span class="fa fa-remove"></span></a>
                                    </li>
                                    <li><strong>Category</strong>: {{$tickets[0]->subname}}</li>
                                    <li><strong>Email</strong>: {{$tickets[0]->email}}</li>
                                    <li><strong>Created</strong>: <time title="{{$tickets[0]->created_at}}">{{ Carbon\Carbon::parse($tickets[0]->created_at)->diffForHumans()}}</time></li>
                                    <li><strong>Last Update</strong>: <time id="updatedt_at" title="{{$tickets[0]->updated_at}}">{{ Carbon\Carbon::parse($tickets[0]->updated_at)->diffForHumans()}}</time></li>
                                </ul>
                        </div>

                        <div class="ticket-point col-lg-6 col-sm-6">
                            <hr class="login_to_shop" style="display:none; height: 1px; width:50%; margin:15px 0;">
                            <ul>
                                <li><strong>Store ID</strong>: <a href="{!! str_replace('support/', '', $tickets[0]->base_url) !!}administrator/shopDetail.php?id={{ $shopdetails[0]->shop_id }}" target="_blank">{{ $shopdetails[0]->shop_id }}</a></li>
                                <li><strong>Store Name</strong>: <a href="https://{{ $shopdetails[0]->shop_shopify_domain }}" target="_blank">{{ $shopdetails[0]->shop_name }}</a></li>
                                <li><strong>Store owner's Name</strong>: {{ $shopdetails[0]->shop_owner_name }}</li>
                                <li><strong>Store owner's email</strong>: <span id="textToCopy">{{ $shopdetails[0]->shop_owner_email }}</span> &nbsp;
                                <a href="javascript:void(0)" class="textToCopy" title="Copy to clipboard" data-clipboard-target="#textToCopy" class="pedit" style="color:#21a9ec;font-size: 17px;"><span class="fa fa-clipboard"></span></a></li>
                                <li><strong>Custom Domain</strong>:
                                <a href="https://{{ $shopdetails[0]->shop_domain }}" target="_blank">{{ $shopdetails[0]->shop_domain }}</a>
                                </li>
                                <li><strong>Shopify Domain</strong>: 
                                    <a href="https://{{ $shopdetails[0]->shop_shopify_domain }}" target="_blank">{{ $shopdetails[0]->shop_shopify_domain }}</a>
                                    <a href="https://{{ $shopdetails[0]->shop_shopify_domain }}/admin" target="_blank" style="display: inline-block;vertical-align: top;" title="https://{{ $shopdetails[0]->shop_shopify_domain }}/admin">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20">
  <path fill="#5E5F5F" d="M13.897 3.269l.665.663 1.521.114a.183.183 0 0 1 .165.155l2.063 14.029-5.03 1.094.616-16.055zm-.773-.527a.76.76 0 0 0-.095.019l-.564.175c-.336-.976-.932-1.871-1.979-1.871-.028 0-.059.001-.088.003C10.1.673 9.732.5 9.414.5 6.976.5 5.81 3.564 5.445 5.12l-1.706.532c-.529.167-.546.184-.615.684-.052.38-1.436 11.134-1.436 11.134l10.783 2.03.011-.003.642-16.755zm-2.806.756v.106l-1.884.586c.362-1.407 1.042-2.087 1.637-2.344.15.379.247.92.247 1.652zm-.972-2.34c.106 0 .211.036.313.105-.782.37-1.618 1.3-1.972 3.159l-1.49.465c.415-1.419 1.398-3.729 3.149-3.729zm.421 8.285s-.631-.337-1.405-.337c-1.134 0-1.191.715-1.191.895 0 .983 2.551 1.36 2.551 3.663 0 1.813-1.144 2.98-2.687 2.98-1.85 0-2.796-1.157-2.796-1.157l.495-1.646s.974.84 1.794.84c.537 0 .754-.425.754-.733 0-1.283-2.093-1.341-2.093-3.449 0-1.775 1.268-3.492 3.826-3.492.985 0 1.471.285 1.471.285l-.719 2.151zm1.191-6.039v-.196c0-.606-.084-1.095-.217-1.481.54.068.898.685 1.129 1.394l-.912.283z"/>

                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="col-md-12 login_to_shop" style="display: none;">
							<a href="{!! str_replace('support/', '', $tickets[0]->base_url) !!}shop_index.php?domain={{ $shopdetails[0]->shop_domain }}&secret={{ $shopdetails[0]->shop_secret }}" target="_blank" class="btn">Login to Shop</a></h2>
				        </div>
                        <div class="col-md-12">
                            <hr style="height: 1px; width:100%; margin:15px 0;">
                            <h3>Description:</h3>
                                <div id="stuff" style="display: none;">{!! $tickets[0]->content !!}</div>
                                <div class="stuff">{!! $tickets[0]->content !!}</div>
                                <div class="tickets_attachements_rows">
                                @foreach ($tickets_attachements as $attach)
                                
                                    @if(($attach->comment_id) == 0 && $attach->file_name !='blob')
                                    <div class="imgpicattach">
                                      <div class="thumbnail-attach">
                                    
                                        @if(in_array($attach->file_ext, ['png','jpeg','jpg']))
                                            <img src="{{ url('img/atteach') }}/{{$attach->file_name}}" class="attach-img-tag" height="120" width="160" />
                                        @else
                                            <img src="{{ url('img') }}/default-attachment.png" class="attach-img-tag" height="120" width="160" />
                                        @endif
                                          <div class="caption">
                                            <p>{{$attach->file_name}}</p>
                                          </div>
                                    
                                      </div>
                                    </div>
                                    
                                     @endif
                                
                                @endforeach
                                </div>
                        </div>
                    </div>
                </div>
            </div> 
    <div class="allcomments">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="card-title">Comment</h3>
                            <!-- Create the editor container -->
                            <div class="ticket-commentbar">
                @if($comments->isEmpty() )
                                                  
                @endif
                <ul class="messages_layout">
                        @foreach($tickets_notifications as $tnotify)
                            @if($tnotify->last_comments_id == 0)
                                @if($tnotify->status_id != 1)
                                <li class="left">
                                    <div class="message_wrap1 alert alert-info">
                                    <span class="status-notification">Status Set To <b>{{$tnotify->status_name}}</b>
                                    @if($tnotify->time_durations_id != 0)
                                    On <b>{{$tnotify->duration_name}}</b>
                                    @endif
                                    , Updated By <b>{{ $tnotify->uname }}</b></span></div></li>
                                @endif
                            @endif
                        @endforeach
                    
                    @foreach ($comments as $cmnt)
                    <li class="from_user {{ ($cmnt->commentable_type == 0) ? 'right' : 'left' }}"> <a href="#" class="avatar" title="{{ $cmnt->uname }}"><figure><img src="{{ Gravatar::src($cmnt->uemail, 40) }}"><figcaption>{{ $cmnt->uname }}</figcaption></figure></a>
                        <div class="message_wrap {{ ($cmnt->support_team_display == 1) ? 'admincomments' : '' }}">
                            <div class="text">{!! $cmnt->content !!}
                               <div class="row2">
                            @foreach ($tickets_attachements as $attach)
                               
                                @if(($cmnt->id) == ($attach->comment_id))
                                            <div class="imgpicattach">
                                              <div class="thumbnail-attach">
                                            
                                                @if(in_array($attach->file_ext, ['png','jpeg','jpg']))
                                                    <img src="{{ url('img/atteach') }}/{{$attach->file_name}}" class="attach-img-tag" />
                                                @else
                                                    <img src="{{ url('img') }}/default-attachment.png" class="attach-img-tag" />
                                                @endif
                                                  <div class="caption">
                                                    <p>{{$attach->file_name}}</p>
                                                  </div>
                                            
                                              </div>
                                            </div>
                
                                             @endif
                
                                        @endforeach
                                        </div>
                            </div>

                            <span class="arrow"></span>
                            <div class="info">
                                <span class="time"><i class=" icon-time"></i> <time title="{{$cmnt->updated_at}}">{{ Carbon\Carbon::parse($cmnt->updated_at)->diffForHumans()}}</time> </span>
                            </div>

                        </div>
                    </li>
                        @foreach($tickets_notifications as $tnotify)
                            @if(($cmnt->id) == ($tnotify->last_comments_id))
                                <li class="left">
                                    <div class="message_wrap1 alert alert-info">
                                    <span class="status-notification">Status Set To <b>{{$tnotify->status_name}}</b>
                                    @if($tnotify->time_durations_id != 0)
                                    On <b>{{$tnotify->duration_name}}</b>
                                    @endif, Updated By <b>{{ $tnotify->uname }}</b></span>
                                </div>
                                </li>
                            @endif
                        @endforeach
                    @endforeach
                </ul>
                </div>
            </div>
        </div>
    </div>
</div>   


    <div class="row">
        <div class="col-md-12">
            <div class="msgsuccess"></div>
            <h3>Reply:</h3>
            <div class="form-group">
                <input name="ticket_id" id="ticket_id" type="hidden" value="{{$tickets[0]->id}}">
                <input name="user_ids" id="user_ids" type="hidden" value="{{$tickets[0]->user_id}}">
                <textarea class="ckeditor" name="content" cols="30" id="content" placeholder="Describe your issue here in details"></textarea>
                <span class="text-danger contenterror"></span>
            </div>
            <div class="form-group">
                <form action="{{ url('/updatemultipleimages') }}" enctype="multipart/form-data" class="dropzone" id="image-upload"></form>
                <br/>
                <b>Note:</b> 1) You can upload maximum 5 files. File size should not exceed 5MB. <br/> 2)If you have to upload a screencast video, kindly upload it to either Google Drive or Dropbox and then share its link in the Request Description.
                <ul class="status-container pull-right">
                <strong>Status</strong>:</td><td> <label class="status_name" style="display:inline-block;">
                <span style="color: {{$tickets[0]->scolor}}">{{$tickets[0]->sname}}</span> &nbsp;
                </label>

                <select name="sp_status" id='sp_status' class='status_com_text droparrow' style="display: none;">
                @foreach ($statuses as $status)
                <option value="{{ $status->name }}" data-id="{{$status->id}}"> {{ $status->name }}</option>
                @endforeach
                </select>
                <select id="time_durations" class="droparrow" name="time_durations" style="display: none;">
                <option value="0" data-id="0">Select Duration</option>
                @foreach ($time_durations as $durations)
                <option value="{{ $durations->id }}" data-id="{{$durations->id}}"> {{ $durations->name }}</option>
                @endforeach
                </select>           
                <a href="javascript:void(0)" class='status_edit' style="color:#21a9ec;font-size: 17px;">
                <span class="fa fa-pencil"></span>
                </a>
                <a href="javascript:void(0)" class='status_save' style="display: none;font-size: 20px;">
                <span class="fa fa-check"></span>
                </a>
                <a href="javascript:void(0)" class='status_cancel' style="display: none;color:#bd2b1f;font-size: 20px;">
                <span class="fa fa-remove"></span>
                </a>
                <span id="loading_status_last" style="display:none;"><img src="{{asset('images')}}/loading.gif" height="25" width="80" /></span>

                </ul>
            </div>
            <div class="form-group">
                @guest
                    <input type="hidden" id="commentable_type" name="commentable_type" class="form-control" value="0">
                    <input type="hidden" id="support_team_display" name="support_team_display" value="0" id="support_team_display">
                @else
                    <div class="form-group">
                        <div class="col-lg-12">
                            <label><input type="checkbox" name="support_team_display" value="1" id="support_team_display"> Visible only to Support Team</label>
                        </div>
                    </div>
                    <input type="hidden" name="commentable_type" id="commentable_type" class="form-control" value="1">
                @endguest                            
                <button class="btn btn-save" type="submit">Save</button>
                <span id="loading" style="display:none;"><img src="{{asset('images')}}/loading.gif" height="50" width="100" /></span>
            </div>
        </div>
    </div>
</div>
</div>
@endsection

@section('scripts')
    <script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
    <script src="https://cdn.ckeditor.com/4.11.1/standard-all/ckeditor.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.2.0/min/dropzone.min.js"></script>
     <script src="{{ asset('js/simple-lightbox.min.js') }}"></script>
<script src="https://cdn.jsdelivr.net/clipboard.js/1.5.16/clipboard.min.js"></script>

<script type="text/javascript">
$("#time_durations").hide();
$("#sp_status").on( 'change', function (event) {
    event.preventDefault();
    var appFilter = $("#sp_status option:selected").attr('data-id'); 
    //alert(appFilter);
        if(appFilter == 4 || appFilter == 5)
        {
            $("#time_durations").show();
        }
        else
        {
            $("#time_durations").hide();
        }                   
} );

$("#time_main_durations").hide();
$("#sp_main_status").on( 'change', function (event) {
    event.preventDefault();
    var appFilter = $("#sp_main_status option:selected").attr('data-id');  
    //alert(appFilter);
        if(appFilter == 4 || appFilter == 5)
        {
            $("#time_main_durations").show();
        }
        else
        {
            $("#time_main_durations").hide();
        }                   
} );

Dropzone.options.imageUpload = {
    maxFilesize:5,
    maxFiles: 5,
};
Dropzone.autoDiscover = false;

var myDropzone = $(".dropzone").dropzone({
 addRemoveLinks: true,
    params: {
        _token: '{{csrf_token()}}',
        ticket_id : $('#ticket_id').val()
    },
    success: function(file, response){
        file.attachment_id = response;
    },
 removedfile: function(file) {
  var name = file.name; 
   
  $.ajax({
   type: 'POST',
   url: '{{ url('/updatemultipleimages') }}',
   data: {name: name,request: 2,_token: '{{csrf_token()}}',atach_id:file.attachment_id},
   sucess: function(data){
    console.log('success: ' + data);
   }
  });
  var _ref;
  return (_ref = file.previewElement) != null ? _ref.parentNode.removeChild(file.previewElement) : void 0;
 }
});
    
            //ajax form submit with commented

        function time_ago(time) {

            switch (typeof time) {
                case 'number':
                    break;
                case 'string':
                    time = +new Date(time);
                    break;
                case 'object':
                    if (time.constructor === Date) time = time.getTime();
                    break;
                default:
                    time = +new Date();
            }
            var time_formats = [
                [60, 'seconds', 1], // 60
                [120, '1 minute ago', '1 minute from now'], // 60*2
                [3600, 'minutes', 60], // 60*60, 60
                [7200, '1 hour ago', '1 hour from now'], // 60*60*2
                [86400, 'hours', 3600], // 60*60*24, 60*60
                [172800, 'Yesterday', 'Tomorrow'], // 60*60*24*2
                [604800, 'days', 86400], // 60*60*24*7, 60*60*24
                [1209600, 'Last week', 'Next week'], // 60*60*24*7*4*2
                [2419200, 'weeks', 604800], // 60*60*24*7*4, 60*60*24*7
                [4838400, 'Last month', 'Next month'], // 60*60*24*7*4*2
                [29030400, 'months', 2419200], // 60*60*24*7*4*12, 60*60*24*7*4
                [58060800, 'Last year', 'Next year'], // 60*60*24*7*4*12*2
                [2903040000, 'years', 29030400], // 60*60*24*7*4*12*100, 60*60*24*7*4*12
                [5806080000, 'Last century', 'Next century'], // 60*60*24*7*4*12*100*2
                [58060800000, 'centuries', 2903040000] // 60*60*24*7*4*12*100*20, 60*60*24*7*4*12*100
            ];
            var seconds = (+new Date() - time) / 1000,
                token = 'ago',
                list_choice = 1;

            if (seconds == 0) {
                return 'Just now'
            }
            if (seconds < 0) {
                seconds = Math.abs(seconds);
                token = 'from now';
                list_choice = 2;
            }
            var i = 0,
                format;
            while (format = time_formats[i++])
                if (seconds < format[0]) {
                    if (typeof format[2] == 'string')
                        return format[list_choice];
                    else
                        return Math.floor(seconds / format[2]) + ' ' + format[1] + ' ' + token;
                }
            return time;
        }

        $(document).ready(function()
        {
            $(".attach-img-tag").simpleLightBox();
        
            $( ".btn-save" ).click(function() {
                for (instance in CKEDITOR.instances) {
                    CKEDITOR.instances[instance].updateElement();
                }

                if($('#content').val() == '')
                {
                    $(".contenterror").text("Enter Describe your issue here in details");
                }
                else{
                    
                    

            $(".btn-save").hide();
            $("#loading").show();
            

                    var form_data = new FormData();                  // Creating object of FormData class
                    
                   @if(Auth::user())
                        form_data.append("user_id", {{Auth::user()->id}});
                   @else
                        form_data.append("user_id", $('#user_ids').val());
                   @endif
                   
                    form_data.append("content", $('#content').val());
                    form_data.append("commentable_type", $('#commentable_type').val());
                    form_data.append("ticket_id", $('#ticket_id').val());
                    if($('#support_team_display').prop("checked") == true){
            
                        form_data.append("support_team_display", 1);
                        var superadmin = "admincomments";
                    }
                    else if($('#support_team_display').prop("checked") == false){
                        form_data.append("support_team_display", 0);
                        var superadmin = "123";
                    }
                    
                    form_data.append("_token", '{{csrf_token()}}');


                    $.ajax({
                        type:"POST",
                        dataType:"json",
                        url:"{{ url('ticketcomments') }}",
                        cache: false,
                        contentType: false,
                        processData: false,
                        data: form_data,
                        success: function (data) {
                            
                            $('.dropzone')[0].dropzone.files.forEach(function(file) { 
                              file.previewElement.remove(); 
                            });

                            $('.dropzone').removeClass('dz-started');
                            
                            $('#content').val('');
                            $('#imagevalue').val('');
                            $(".contenterror").text("");
                            $(".imagevalueerror").text("");
                            $("#loading").hide();
                            $(".btn-save").show();
                            $("#blankcomment").hide();
                            CKEDITOR.instances.content.setData( '' );
                            $('#support_team_display').attr('checked',false);
                            if(data.comment[0].commentable_type == 0){
                                var side = "right";
                                var useradminicon="user";
                            }
                            else {
                                var side = "left";
                                var useradminicon="admin";
                            }
                            var updated_at= data.comment[0].updated_at;
                            var updated_final_at= time_ago(new Date(Date.now()));
                            var username = data.comment[0].uname;
                            var gravatar_img = "{{ Gravatar::src('admin@simprosys.net', 40) }}";
                            

                            var total_attach_files = data.tickets_attachements.length;
                            var total_attachements_str = '';
                            var ar_ext = ['jpg', 'gif', 'png', 'jpeg']; 
                            total_attachements_str += "<div class='row'>";
                             for(var i=0;i<total_attach_files;i++)
                             {
                                if (ar_ext.indexOf(data.tickets_attachements[i].file_ext) === -1) {
                                    total_attachements_str +="<div class='col-md-2'><div class='thumbnail-attach'><img src='{{ url('img') }}/default-attachment.png' class='attach-img-tag smp-lightbox'><div class='caption'><p>"+data.tickets_attachements[i].file_name+"</p></div></div></div>";

                                }
                                else {
                                 total_attachements_str +="<div class='col-md-2'><div class='thumbnail-attach'><img src='{{ url('img/atteach') }}/"+data.tickets_attachements[i].file_name+"' class='attach-img-tag smp-lightbox'><div class='caption'><p>"+data.tickets_attachements[i].file_name+"</p></div></div></div>";
                                }
                             }
                            total_attachements_str += "</div>";
                            
                            
                            $('time[id="updatedt_at"]').text(updated_final_at);
                            $(".messages_layout").append('<li class="from_user ' + side + '"> <a href="#" class="avatar" title="' + username + '"><figure><img src="'+ gravatar_img +'" /><figcaption>' + username + '</figcaption></figure></a> <div class="message_wrap"><div class="text">'+data.comment[0].content + total_attachements_str +'</div><span class="arrow"></span> <div class="info"><span class="time"><i class="icon-time"></i><time title="'+ updated_at +'"> '+ updated_final_at +' </time></span> </div> </div></li>');
                           // $(".messages_layout").append('<li class="from_user ' + side + '"> <a href="#" class="avatar" title="' + username + '"><img src="{{asset('img')}}/'+ useradminicon +'.png" height="25" width="25" /></a> <div class="message_wrap"><div class="text">'+data.comment[0].content+'</div><span class="arrow"></span> <div class="info"> <span class="time"><i class="icon-time"></i><time title="'+ updated_at +'"> '+ updated_final_at +' </time></span> </div> </div></li>');
                            $(".message_wrap").last().addClass(superadmin);
                            $(".msgsuccess").html('<div class="alert alert-success msgsuccessdata">Comment has been added successfully</div>');
                           $(".attach-img-tag").simpleLightBox();
                            $(".attach-img-tag").addClass("smp-lightbox");
                            setTimeout(function() {
                                $(".msgsuccessdata").hide();
                            }, 3000);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                            var obj = {
                            };
                        }
                    });
                }
            });
        });
    
        $(document).ready(function()
        {

            $('.com_text').click(function()
            {
                var com_text = $(this).attr('id');
            });

            $('.pcom_text').click(function()
            {
                var pcom_text = $(this).attr('id');
            });

            //Edit
            $('.edit').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.item-container'),
                    currentItemLabel = itemWrapper.find('.name').text().trim();

                itemWrapper.find('.name').hide();
                itemWrapper.find('.save,.cancel').show();
                itemWrapper.find('.com_text').val(currentItemLabel);
                itemWrapper.find('.com_text').show();
            });

            $('.pedit').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.item-container'),
                    currentItemLabel = itemWrapper.find('.pname').text().trim();

                itemWrapper.find('.pname').hide();
                itemWrapper.find('.psave,.pcancel').show();
                itemWrapper.find('.pcom_text').val(currentItemLabel);
                itemWrapper.find('.pcom_text').show();
            });

            //Cancel
            $('.cancel').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.item-container');

                itemWrapper.find('.name,.edit').show();
                itemWrapper.find('.save').hide();
                itemWrapper.find('.com_text').hide();
                itemWrapper.find('.com_text').val('');
                $("#time_main_durations").hide();

            });

            $('.pcancel').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.item-container');

                itemWrapper.find('.pname,.pedit').show();
                itemWrapper.find('.psave').hide();
                itemWrapper.find('.pcom_text').hide();
                itemWrapper.find('.pcom_text').val('');

            });

            //Save
            $('.save').click(function()
            {
                $("#loading_status").show();
                
                var itemWrapper = $(this).closest('.item-container');
                var sname = itemWrapper.find('.com_text').val().trim();
                var ticket_id = $("input[name=ticket_id]").val();
                var status_id = itemWrapper.find('.com_text').find(':selected').attr('data-id');
                var dataobj = {};
                // dataobj.sid = $(this).attr('data-id');
                dataobj.status_id = status_id.trim();
                dataobj.sname = sname.trim();
                dataobj.ticket_id = ticket_id.trim();
                
                dataobj.time_durations = $('#time_main_durations option:selected').val();
                dataobj.user_id = $('#user_ids').val();
                
                dataobj._token = '{{csrf_token()}}';
                // alert(JSON.stringify(dataobj));
                // Your Ajax Code Here
                // Then run this on success to handle updating
                $.ajax(
                    {
                        type:"POST",
                        dataType:"json",
                        url:"{{ url('/updateStatus') }}",
                        cache: false,
                        data: dataobj,
                        success:function(response)
                        {

                            $(".name").css("color", response['color'][0].color);
                            itemWrapper.find
                            itemWrapper.find('.name').html(sname.trim());
                            itemWrapper.find('.name,.edit').show();
                            itemWrapper.find('.save,.cancel').hide();
                            itemWrapper.find('.com_text').hide();
                            itemWrapper.find('.com_text').val('');
                                                        itemWrapper.find('#time_main_durations').val('');
                            $("#time_main_durations").hide();

                            $("#loading_status").hide();
                            var notifymessages = "";
                            if(response['notification'][0].time_durations_id != 0)
                            {
                                notifymessages += "On <b>"+response['notification'][0].duration_name+"</b>";
                            }
                            $(".messages_layout").append('<li class="left"><div class="message_wrap1 alert alert-info"><span class="status-notification">Status Set To <b>'+response['notification'][0].status_name+'</b>On <b>'+notifymessages+'</b>, Updated By <b>'+response['notification'][0].uname+'</b></span></div></li>');
                        }
                    });



            });

            //Save
            $('.psave').click(function()
            {

                var itemWrapper = $(this).closest('.item-container');
                var pname = itemWrapper.find('.pcom_text').val().trim();
                var ticket_id = $("input[name=ticket_id]").val();
                var priority_id = itemWrapper.find('.pcom_text').find(':selected').attr('data-id')
                var dataobj = {};
                // dataobj.sid = $(this).attr('data-id');
                dataobj.priority_id = priority_id.trim();
                dataobj.pname = pname.trim();
                dataobj.ticket_id = ticket_id.trim();
                dataobj._token = '{{csrf_token()}}';
                //  alert(JSON.stringify(dataobj));

                // Your Ajax Code Here
                // Then run this on success to handle updating
                $.ajax(
                    {
                        type:"POST",
                        dataType:"json",
                        url:"{{ url('/updatepriorities') }}",
                        cache: false,
                        data: dataobj,
                        success:function(response)
                        {

                            // ver rescolor = response['color'][0].color;

                            $(".pname").css("color", response['color'][0].color);

                            itemWrapper.find
                            itemWrapper.find('.pname').html(pname.trim());
                            itemWrapper.find('.pname,.pedit').show();
                            itemWrapper.find('.psave,.pcancel').hide();
                            itemWrapper.find('.pcom_text').hide();
                            itemWrapper.find('.pcom_text').val('');
                            $("#time_main_durations").hide();
                        }
                    });
            });
            
                        $('.status_com_text').click(function()
            {
                var status_com_text = $(this).attr('id');
            });


            //Edit
            $('.status_edit').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.status-container'),
                    currentItemLabel = itemWrapper.find('.status_name').text().trim();

                itemWrapper.find('.status_name').hide();
                itemWrapper.find('.status_save,.status_cancel').show();
                itemWrapper.find('.status_com_text').val(currentItemLabel);
                itemWrapper.find('.status_com_text').show();
            });
 
            //Cancel
            $('.status_cancel').click(function()
            {
                $(this).hide();
                var itemWrapper = $(this).closest('.status-container');

                itemWrapper.find('.status_name,.status_edit').show();
                itemWrapper.find('.status_save').hide();
                itemWrapper.find('.status_com_text').hide();
                itemWrapper.find('.status_com_text').val('');
                $("#time_durations").hide();

            });
            //Save
            $('.status_save').click(function()
            {
                var itemWrapper = $(this).closest('.status-container');
                var sname = itemWrapper.find('.status_com_text').val().trim();
                var ticket_id = $("input[name=ticket_id]").val();
                var status_id = itemWrapper.find('.status_com_text').find(':selected').attr('data-id')
                var dataobj = {};
                // dataobj.sid = $(this).attr('data-id');
                dataobj.status_id = status_id.trim();
                dataobj.sname = sname.trim();
                dataobj.ticket_id = ticket_id.trim();

                dataobj.time_durations = $('#time_durations option:selected').val();
                dataobj.user_id = $('#user_ids').val();

                dataobj._token = '{{csrf_token()}}';
                // alert(JSON.stringify(dataobj));
                // Your Ajax Code Here
                // Then run this on success to handle updating
                $.ajax(
                    {
                        type:"POST",
                        dataType:"json",
                        url:"{{ url('/updateStatus') }}",
                        cache: false,
                        data: dataobj,
                        success:function(response)
                        {
                            console.log(response);
                            $(".status_name").css("color", response['color'][0].color);
                            itemWrapper.find
                            itemWrapper.find('.status_name').html(sname.trim());
                            itemWrapper.find('.status_name,.status_edit').show();
                            itemWrapper.find('.status_save,.status_cancel').hide();
                            itemWrapper.find('.status_com_text').hide();
                            itemWrapper.find('.status_com_text').val('');
                            itemWrapper.find('#time_durations').val('');
                            $("#time_durations").hide();

                            var notifymessages = "";
                            if(response['notification'][0].time_durations_id != 0)
                            {
                                notifymessages += "On <b>"+response['notification'][0].duration_name+"</b>";
                            }
                            $(".messages_layout").append('<li class="left"><div class="message_wrap1 alert alert-info"><span class="status-notification">Status Set To <b>'+response['notification'][0].status_name+'</b>On <b>'+notifymessages+'</b>, Updated By <b>'+response['notification'][0].uname+'</b></span></div></li>');
                        }
                    });



            });

            
 
               //deal with copying the ckeditor text into the actual textarea
        CKEDITOR.on('instanceReady', function () {
        $.each(CKEDITOR.instances, function (instance) {
            CKEDITOR.instances[instance].document.on("keyup", CK_jQ);
            CKEDITOR.instances[instance].document.on("paste", CK_jQ);
            CKEDITOR.instances[instance].document.on("keypress", CK_jQ);
            CKEDITOR.instances[instance].document.on("blur", CK_jQ);
            CKEDITOR.instances[instance].document.on("change", CK_jQ);
        });
        });
        
        function CK_jQ() {
        for (instance in CKEDITOR.instances) {
            CKEDITOR.instances[instance].updateElement();
        }
        }
        
        CKEDITOR.config.toolbar = [
            ['Bold','Italic','Underline','myCombo']

        ] ;
            
        CKEDITOR.replace( 'content', {
                extraPlugins: 'autogrow',
                toolbarGroups: [
                    { name: 'mode' },
                    { name: 'basicstyles' },
                    { name: 'styles' }        
               ],
                on: {        
                    pluginsLoaded: function() {
                        var editor = this,
                            config = editor.config;
                        
                        function parseSpan( color ) {
                           // return '<span style="color:' + color + '">' + color + '</span>';
                           //console.log(color);
                           return color;
                        }
                        function htmlDecode(input){
                          var e = document.createElement('div');
                          e.innerHTML = input;
                          return e.childNodes[0].nodeValue;
                        } 
                        
                        var acfRules = 'span{color}';
                     
                        editor.ui.addRichCombo( 'myCombo', {
                            label: 'Canned responses',
                            title: 'Canned responses',
                            toolbar: 'styles',
                            
                            allowedContent: acfRules,
                            
                            requiredContent: acfRules,
               
                            panel: {
                                css: [ CKEDITOR.skin.getPath( 'editor' ) ].concat( config.contentsCss ),
                                multiSelect: false
                            },
                
                            init: function() {
                                this.startGroup( 'Canned responses' );
                                
            
            
                                var items = JSON.parse(htmlDecode('{{$cannedresponses}}'));   
                                 
            
                                //var items =[{"title":"This is a test responses","content":"<p>This is a test responses<\/p>"},{"title":"second canned response","content":"<p>second canned response<\/p>"},{"title":"simple new responsed","content":"<p>simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed&nbsp;simple new responsed<\/p>"}];
                                //console.log(items);
                                for ( var i = 0; i < items.length; i++ ) {
                                    var item = items[ i ];
                                    var content  = item.content.replace(/\n|\r/g, "");
                                    this.add(content, parseSpan( item.title), item.title );
                                }
                            },
            
                            onClick: function( value ) {
                                editor.focus();
                            
                                editor.fire( 'saveSnapshot' );
                               
                                editor.insertHtml( parseSpan( value ) );                    
                                
                                editor.fire( 'saveSnapshot' );
                            },
                            onRender: function() {
                            },
                            onOpen: function() {
                            },
                            refresh: function() {
                                if ( !editor.activeFilter.check( acfRules ) )
                                    this.setState( CKEDITOR.TRISTATE_DISABLED );
                            }
                        } );            
                    }
                }
            } );    
            
            
        });



        $("#form").validate({
            rules: {
                content: {
                    required: true,
                    minlength: 10
                }
            },
            messages: {
                content: {
                required: "Enter Describe your issue here in details",
                    minlength: "Minimum password length is 10"
            }
        },
            submitHandler: function(form) {
                form.submit();
            }
        });
        

    $(document).ready(function () {

   var menu = $('.ticket-sidebar');
    var origOffsetY = menu.offset().top ;
    var new_count = origOffsetY+$('.ticket-sidebar').height()+60;
    function scroll() {
        if ($(window).scrollTop() >= new_count) {
            $('.main-tops-part').css("height", new_count);
            $('.allcomments').addClass('col-lg-8');
            
            $('.ticket-sidebar').addClass('col-md-3 rail page-bx');
            $('.ticket-point').addClass('col-lg-12');
            $('.login_to_shop').show();
            $('.tickets_attachements_rows').hide();
            $('.stuff').hide();
            $('#stuff').show();
            
        } else {
            $('.main-tops-part').css("height", 0);
            //$('.ticket-sidebar').css("height", origOffsetY);
            $('.allcomments').removeClass('col-lg-8');
            $('.ticket-sidebar').removeClass('col-md-3 rail page-bx');
            $('.ticket-point').removeClass('col-lg-12');
            $('.login_to_shop').hide();
            $('.tickets_attachements_rows').show();
            $('.stuff').show();
            $('#stuff').hide();
            cutString('stuff'); 
        }
    }

if ($(window).width() >= 767) {
    document.onscroll = scroll;
}


function cutString(id){    
     var text = document.getElementById(id).innerHTML;         
     var charsToCutTo = 130;
        if(text.length>charsToCutTo){
            var strShort = "";
            for(i = 0; i < charsToCutTo; i++){
                strShort += text[i];
            }
            document.getElementById(id).title = "More..";
            document.getElementById(id).innerHTML = strShort + "&nbsp;&nbsp;<a href=''>More</a>...";
        }            
     };

 var clipboard = new Clipboard('.textToCopy');
 clipboard.on('success', function(e) {
   console.log(e);
 });
 clipboard.on('error', function(e) {
   console.log(e);
 });


});
    </script>
@stop