@extends('layouts.layout')

@section('content')
@if ($message = Session::get('success'))
<div class="alert alert-success">
    <p>{{ $message }}</p>
</div>
@endif




<div class="panel panel-default">
    <div class="panel-body">
        <div class="content">
            <h2 class="header">
                {{$tickets[0]->subject}}.
                <span class="pull-right">


<form action="{{ route('tickets.destroy',$tickets[0]->id) }}" method="POST">
    @if($tickets[0]->status_id == 2)
        <a href="{{ route('tickets.edit',['id' => $tickets[0]->id, 'status_id' => 1]) }}" class="btn btn-success">Reopen Complete</a>
    @else
        <a href="{{ route('tickets.edit',['id' => $tickets[0]->id, 'status_id' => 2]) }}" class="btn btn-success">Mark Complete</a>
    @endif
@csrf
@method('DELETE')
@auth
<button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete the App: {{ $tickets[0]->subject }} ?')">Delete</button>
@endauth
</form>


</span></h2>



            <div class="panel well well-sm">
                <div class="panel-body">
                    <div class="col-md-12 label-1 item-container">
                        <div class="col-md-6">
                            <p> <strong>App</strong>: {{$tickets[0]->cname}}</p>
                            <p>
                                <strong>Status</strong>:
                                <label class="name">
                                    <span style="color: {{$tickets[0]->scolor}}">{{$tickets[0]->sname}}</span> &nbsp;
                                </label>
                                @auth
                                <select id='text_1' class='com_text' style="display: none;">
                                    @foreach ($statuses as $status)
                                    <option value="{{ $status->name }}" data-id="{{$status->id}}"> {{ $status->name }}</option>
                                    @endforeach
                                </select>
                                <a href="#" class='edit'>
                                    <span class="glyphicon glyphicon-pencil"></span>
                                </a>
                                <a href="#" class='save' style="display: none;">
                                    <span class="glyphicon glyphicon-ok"></span>
                                </a>
                                <a href="#" class='cancel' style="display: none;">
                                    <span class="glyphicon glyphicon-remove"></span>
                                </a>
                                @endauth
                            </p>
                            <p>
                                <strong>Priority</strong>:
                                <label class="pname">
                                    <span style="color: {{$tickets[0]->pcolor}}">{{$tickets[0]->pname}}</span> &nbsp;
                                </label>
                                @auth
                                <select id='text_2' class='pcom_text' style="display: none;">
                                    @foreach ($priority as $prty)
                                    <option value="{{ $prty->name }}" data-id="{{$prty->id}}"> {{ $prty->name }}</option>
                                    @endforeach
                                </select>
                                <a href="#" class='pedit'>
                                    <span class="glyphicon glyphicon-pencil"></span>
                                </a>
                                <a href="#" class='psave' style="display: none;">
                                    <span class="glyphicon glyphicon-ok"></span>
                                </a>
                                <a href="#" class='pcancel' style="display: none;">
                                    <span class="glyphicon glyphicon-remove"></span>
                                </a>
                                @endauth
                            </p>
                            <p>
                                <strong>Category</strong>:
                                {{$tickets[0]->subname}}
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p> <strong>Email</strong>: {{$tickets[0]->email}}</p>
                            <p> <strong>Created</strong>: {{ Carbon\Carbon::parse($tickets[0]->created_at)->diffForHumans()}}
                            </p>
                            <p> <strong>Last Update</strong>: {{ Carbon\Carbon::parse($tickets[0]->updated_at)->diffForHumans()}}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                {!! $tickets[0]->content !!}
            </div>
        </div>
    </div>
</div>

<br/>
<h2>Comments</h2>
@foreach ($comments as $cmnt)
<div class="panel panel-{{ ($cmnt->support_team_display == 1) ? 'success' : 'primary' }}">
    <div class="panel-heading">
        <h3 class="panel-title">
            @if($cmnt->commentable_type == 0)
            {{$tickets[0]->email}}
            @else
            Admin
            @endif
            <span class="pull-right"> {{ Carbon\Carbon::parse($cmnt->created_at)->diffForHumans()}} </span>
        </h3>
    </div>
    <div class="panel-body">
        <div class="content">
            {!! $cmnt->content !!}
        </div>
    </div>
</div>
@endforeach
<div class="panel-body">
    <form method="POST" action="{{ url('ticketcomments') }}" class="form-horizontal">
        @csrf
        <input name="ticket_id" type="hidden" value="{{$tickets[0]->id}}">
        <fieldset>
            <legend>Reply</legend>
            <div class="form-group">
                <div class="col-lg-12">
                    <textarea class="form-control" name="content" cols="50" id="content" placeholder="Describe your issue here in details"></textarea>
                    @if ($errors->has('content'))
                    <span class="text-danger">{{ $errors->first('content') }}</span>
                    @endif
                </div>
            </div>
            @guest
            <input type="hidden" name="commentable_type" class="form-control" value="0">
            <input type="hidden" name="support_team_display" value="0" id="support_team_display">
            @else
            <div class="form-group">
                <div class="col-lg-12">
                    <input type="hidden" name="support_team_display" value="0">
                    <label><input type="checkbox" name="support_team_display" value="1" id="support_team_display"> Only read support team</label>
                </div>
            </div>
            <input type="hidden" name="commentable_type" class="form-control" value="1">
            @endguest

            <input class="btn btn-primary" type="submit" value="Submit">

        </fieldset>
    </form>
</div>
<link rel="stylesheet" type="text/css" href="{{ asset('css/custom.css') }}" >

<script src="https://cdn.ckeditor.com/ckeditor5/1.0.0-beta.1/classic/ckeditor.js"></script>
<script>

    ClassicEditor
        .create( document.querySelector( '#content' ) )
        .then(editor => {
            document.getElementById('content').innerHTML = editor.getData();

        })
        .catch( error => {
            console.error( error );
        } );

</script>
<script>
    $(document).ready(function()
    {

        $('.com_text').click(function()
        {
            var com_text = $(this).attr('id');
        });

        $('.pcom_text').click(function()
        {
            var pcom_text = $(this).attr('id');
        });

        //Edit
        $('.edit').click(function()
        {
            $(this).hide();
            var itemWrapper = $(this).closest('.item-container'),
                currentItemLabel = itemWrapper.find('.name').text().trim();

            itemWrapper.find('.name').hide();
            itemWrapper.find('.save,.cancel').show();
            itemWrapper.find('.com_text').val(currentItemLabel);
            itemWrapper.find('.com_text').show();
        });

        $('.pedit').click(function()
        {
            $(this).hide();
            var itemWrapper = $(this).closest('.item-container'),
                currentItemLabel = itemWrapper.find('.pname').text().trim();

            itemWrapper.find('.pname').hide();
            itemWrapper.find('.psave,.pcancel').show();
            itemWrapper.find('.pcom_text').val(currentItemLabel);
            itemWrapper.find('.pcom_text').show();
        });

        //Cancel
        $('.cancel').click(function()
        {
            $(this).hide();
            var itemWrapper = $(this).closest('.item-container');

            itemWrapper.find('.name,.edit').show();
            itemWrapper.find('.save').hide();
            itemWrapper.find('.com_text').hide();
            itemWrapper.find('.com_text').val('');

        });

        $('.pcancel').click(function()
        {
            $(this).hide();
            var itemWrapper = $(this).closest('.item-container');

            itemWrapper.find('.pname,.pedit').show();
            itemWrapper.find('.psave').hide();
            itemWrapper.find('.pcom_text').hide();
            itemWrapper.find('.pcom_text').val('');

        });

        //Save
        $('.save').click(function()
        {
            var itemWrapper = $(this).closest('.item-container');
            var sname = itemWrapper.find('.com_text').val().trim();
            var ticket_id = $("input[name=ticket_id]").val();
            var status_id = itemWrapper.find('.com_text').find(':selected').attr('data-id')
            var dataobj = {};
            // dataobj.sid = $(this).attr('data-id');
            dataobj.status_id = status_id.trim();
            dataobj.sname = sname.trim();
            dataobj.ticket_id = ticket_id.trim();
            dataobj._token = '{{csrf_token()}}';
            // alert(JSON.stringify(dataobj));
            // Your Ajax Code Here
            // Then run this on success to handle updating
            $.ajax(
                {
                    type:"POST",
                    dataType:"json",
                    url:"{{ url('/updateStatus') }}",
                    cache: false,
                    data: dataobj,
                    success:function(response)
                    {

                        $(".name").css("color", response['color'][0].color);
                        itemWrapper.find
                        itemWrapper.find('.name').html(sname.trim());
                        itemWrapper.find('.name,.edit').show();
                        itemWrapper.find('.save,.cancel').hide();
                        itemWrapper.find('.com_text').hide();
                        itemWrapper.find('.com_text').val('');
                    }
                });



        });

        //Save
        $('.psave').click(function()
        {

            var itemWrapper = $(this).closest('.item-container');
            var pname = itemWrapper.find('.pcom_text').val().trim();
            var ticket_id = $("input[name=ticket_id]").val();
            var priority_id = itemWrapper.find('.pcom_text').find(':selected').attr('data-id')
            var dataobj = {};
            // dataobj.sid = $(this).attr('data-id');
            dataobj.priority_id = priority_id.trim();
            dataobj.pname = pname.trim();
            dataobj.ticket_id = ticket_id.trim();
            dataobj._token = '{{csrf_token()}}';
            //  alert(JSON.stringify(dataobj));

            // Your Ajax Code Here
            // Then run this on success to handle updating
            $.ajax(
                {
                    type:"POST",
                    dataType:"json",
                    url:"{{ url('/updatepriorities') }}",
                    cache: false,
                    data: dataobj,
                    success:function(response)
                    {

                        // ver rescolor = response['color'][0].color;

                        $(".pname").css("color", response['color'][0].color);

                        itemWrapper.find
                        itemWrapper.find('.pname').html(pname.trim());
                        itemWrapper.find('.pname,.pedit').show();
                        itemWrapper.find('.psave,.pcancel').hide();
                        itemWrapper.find('.pcom_text').hide();
                        itemWrapper.find('.pcom_text').val('');
                    }
                });
        });
    });
</script>
@endsection
