@extends('layouts.layout')
@section('title', 'Tickets')
@section('content')
    <div class="row">
        <div class="span12">
            @if ($message = Session::get('success'))
                <div class="alert alert-success">
                    <p>{{ $message }}</p>
                </div>
            @endif

            <h2>@if($status == 1)
                    Active Tickets
                @else
                    Completed Tickets
                @endif
                <a href="{{ route('tickets.create') }}" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Ticket</a>
            </h2>
            <br/>

            <div class="widget-content">
                <table class="table table table-condensed table-stripe ddt-responsive" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Ticket</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>App</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                </table>
            </div>

            <input type="hidden" value="{{env('DOMAIN_NAME')}}" id="domainname">

            <script>
                var statusId = {{$status}};
                var domainame = $("#domainname").val();
                $(function() {
                    var dtListUsers =  $('#table').DataTable({
                        processing: true,
                        serverSide: true,
                        //dom: '<"wrapper"f<"customefilter">lipt>',
                        dom: '<"wrapper"lf<"customefilter"><t>ip>',
                        ajax: '{{ url('loaddata') }}?action=usertickets&catid=' + statusId + '&domainame='+ domainame,
                        columns: [
                            { data: 'id', name: 'id' },
                            { data: 'subject', name: 'subject' },
                            { data: 'subname', name: 'subname' },
                            { data: 'pname', name: 'pname' },
                            { data: 'cname', name: 'cname' },
                            { data: 'updated_at', name: 'updated_at' },
                            { data: 'sname', name: 'sname' }
                        ],
                        "aaSorting": []
                    });
                    $('.customefilter').html("<label>Filter By App: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                        "                            <option value=\"0\">Select App</option>\n" +
                        "                            @foreach ($category as $cat => $value)\n" +
                        "                                <option value=\"{{ $cat }}\"> {{ $value }}</option>\n" +
                        "                            @endforeach\n" +
                        "                        </select>");
                    $('#statusFilter').on( 'click change', function (event) {
                        event.preventDefault();
                        //dataTable.draw();
                        var filter_value = $(this).val();
                        var new_url = '{{ url('loaddata') }}?action=subfilterusertickets&status=' + filter_value + '&catid=' + statusId + '&domainame='+ domainame;
                        dtListUsers.ajax.url(new_url).load();

                    } );

                });


            </script>
            <style>
                .customefilter{
                    width:300px;
                    float:right;
                }
            </style>
        </div>
    </div>

@endsection