<?php $__env->startSection('title', 'Suggestions'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('errors')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

            <h2>Suggestions Management
                <a href="<?php echo e(route('suggestions.create')); ?>" class="btn pull-right"><i class="icon-plus"></i> Create new Suggestion</a>
            </h2>
    </div>
                <div class="table-bx">
                            <div class="filter-bx">
                                <div class="row">
                                    <div class="col-lg-3 col-sm-6">
                                        <div class="form-group">
                                            <label>Filter By App</label>
                                            <select id="statusFilter" name="search_group_filter" id="statusFilter" class="form-control">
                                                <option value="0">All Apps</option>
                                                <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($cat); ?>"> <?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    <table id="table_tickets" class="table table-striped table-bordered dt-responsive nowrap" style="width:100%">
                        <thead>
                            <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Destination URL</th>
                            <th>Keywords</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                        <tfoot>
                            <tr>
                            <th>ID</th>
                            <th>Title</th>
                            <th>Destination URL</th>
                            <th>Keywords</th>
                            <th>Last Updated</th>
                            <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function() {
           var dtListSuggestion = $('#table_tickets').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('loaddata.index',['action' => 'suggestions'])); ?>',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'title', name: 'title' },
                    { data: 'destination_url', name: 'destination_url' },
                    { data: 'keywords', name: 'keywords' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });


            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
               var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + filter_value;
                dtListSuggestion.ajax.url(new_url).load();

            } );

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>