<?php $__env->startSection('title', 'Suggestions'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>
    <?php if($message = Session::get('errors')): ?>
        <div class="alert alert-danger">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>

            <h2>Suggestions Management
                <a href="<?php echo e(route('suggestions.create')); ?>" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Suggestion</a>
            </h2>
        <br/>
    <div class="widget">
        <div class="widget-header"> <i class="icon-th-list"></i>
            <h3>Suggestion Management</h3>
        </div>
        <!-- /widget-header -->
        <div class="widget-content widget-table action-table">
            <table class="table table-condensed table-stripe ddt-responsive" id="table">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Title</th>
                    <th>Destination URL</th>
                    <th>Keywords</th>
                    <th>Last Updated</th>
                    <th class="td-actions">Actions</th>
                </tr>
                </thead>
            </table>
        </div>
        <!-- /widget-content -->
    </div>
    <!-- /widget -->
    </div>
    <script>
        $(function() {
           var dtListSuggestion = $('#table').DataTable({
                processing: true,
                serverSide: true,
                dom: '<"wrapper"lf<"customefilter"><t>ip>',
                ajax: '<?php echo e(route('loaddata.index',['action' => 'suggestions'])); ?>',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'title', name: 'title' },
                    { data: 'destination_url', name: 'destination_url' },
                    { data: 'keywords', name: 'keywords' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
            $('.customefilter').html("<label>Filter By App: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                    "                            <option value=\"0\">All Apps</option>\n" +
                    "                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>\n" +
                    "                                <option value=\"<?php echo e($cat); ?>\"> <?php echo e($value); ?></option>\n" +
                    "                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>\n" +
                    "                        </select>");
            $('#statusFilter').on( 'change', function (event) {
                event.preventDefault();
                //dataTable.draw();
                var filter_value = $(this).val();
               var new_url = '<?php echo e(url('loaddata')); ?>?action=subsuggestion&status=' + filter_value;
                dtListSuggestion.ajax.url(new_url).load();

            } );
            
        });
    </script>
<style>
    .customefilter{
        width:300px;
        float:right;
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>