<?php $__env->startSection('title', 'Tickets'); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="span12">
            <?php if($message = Session::get('success')): ?>
                <div class="alert alert-success">
                    <p><?php echo e($message); ?></p>
                </div>
            <?php endif; ?>

            <h2><?php if($status == 1): ?>
                    Active Tickets
                <?php else: ?>
                    Completed Tickets
                <?php endif; ?>
                <a href="<?php echo e(route('tickets.create')); ?>" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Ticket</a>
            </h2>
            <br/>

            <div class="widget-content">
                <table class="table table table-condensed table-stripe ddt-responsive" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Ticket</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>App</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                </table>
            </div>

            <input type="hidden" value="<?php echo e($domainname); ?>" id="domainname">

            <script>
                var statusId = <?php echo e($status); ?>;
                var domainame = $("#domainname").val();
                $(function() {
                    var dtListUsers =  $('#table').DataTable({
                        processing: true,
                        serverSide: true,
                        //dom: '<"wrapper"f<"customefilter">lipt>',
                        dom: '<"wrapper"lf<"customefilter"><t>ip>',
                        ajax: '<?php echo e(url('loaddata')); ?>?action=usertickets&catid=' + statusId + '&domainame='+ domainame,
                        columns: [
                            { data: 'id', name: 'id' },
                            { data: 'subject', name: 'subject' },
                            { data: 'subname', name: 'subname' },
                            { data: 'pname', name: 'pname' },
                            { data: 'cname', name: 'cname' },
                            { data: 'updated_at', name: 'updated_at' },
                            { data: 'sname', name: 'sname' }
                        ],
                        "aaSorting": []
                    });
                    $('.customefilter').html("<label>Filter By App: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                        "                            <option value=\"0\">Select App</option>\n" +
                        "                            <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                                <option value=\"<?php echo e($cat); ?>\"> <?php echo e($value); ?></option>\n" +
                        "                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>\n" +
                        "                        </select>");
                    $('#statusFilter').on( 'click change', function (event) {
                        event.preventDefault();
                        //dataTable.draw();
                        var filter_value = $(this).val();
                        var new_url = '<?php echo e(url('loaddata')); ?>?action=subfilterusertickets&status=' + filter_value + '&catid=' + statusId + '&domainame='+ domainame;
                        dtListUsers.ajax.url(new_url).load();

                    } );

                });


            </script>
            <style>
                .customefilter{
                    width:300px;
                    float:right;
                }
            </style>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>