<?php $__env->startSection('content'); ?>
    <?php if($message = Session::get('success')): ?>
        <div class="alert alert-success">
            <p><?php echo e($message); ?></p>
        </div>
    <?php endif; ?>


    <div class="panel panel-default">
        <div class="panel-heading">
            <h2>My Tickets
                <a href="<?php echo e(route('tickets.create')); ?>" class="btn btn-primary pull-right">Create new Tickets</a>
            </h2>
        </div>

        <div id="message"></div>
        <table class="table table-bordered" id="table">
            <thead>
            <tr>
                <th>Id</th>
                <th>Subject</th>
                <th>Status</th>
                <th>Last Updated</th>
                <th>Priority</th>
                <th>App</th>
                <th>Category</th>
            </tr>
            </thead>
        </table>
    </div>
    <script>
        $(function() {
            $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(route('tickets.index')); ?>',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'subject', name: 'subject' },
                    { data: 'status_id', name: 'status_id' },
                    { data: 'created_at', name: 'created_at' },
                    { data: 'pname', name: 'pname' },
                    { data: 'cname', name: 'cname' },
                    { data: 'subname', name: 'subname' }
                ]
            });
        });
    </script>

    </div>
    </div>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>