<?php

namespace App\Http\Controllers;

use App\Users;
use DB;
use Datatables;
use App\Cannedresponse;
use Illuminate\Http\Request;

class CannedresponseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $category = DB::table('categories')->pluck("name","id");
        return view('canned-response.index',compact('category'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        
        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        return view('canned-response.create',compact('category'));    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
           
        Cannedresponse::create([
            'title' => $request['title'],
            'content' => $request['content'],
            'category_id' => json_encode($request['category_ids']),
        ]);
        return redirect('canned-response')->with('success','Canned Response created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Cannedresponse  $cannedresponse
     * @return \Illuminate\Http\Response
     */
    public function show(Cannedresponse $cannedresponse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Cannedresponse  $cannedresponse
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
       $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
       $cannedresponses = \App\Cannedresponse::find($id);
        return view('canned-response.edit',compact('cannedresponses','id','category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Cannedresponse  $cannedresponse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $cannedresponses= \App\Cannedresponse::find($id);
        $cannedresponses->title=$request->get('title');
        $cannedresponses->content=$request->get('content');
        $cannedresponses->category_id=json_encode($request->get('category_ids'));
        $cannedresponses->save();

        return redirect('canned-response')
            ->with('success','Canned Response updated successfully.');
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Cannedresponse  $cannedresponse
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cannedresponses = \App\Cannedresponse::find($id)->delete();
        return redirect('canned-response')->with('success','Canned Response has been deleted');
    }
}
