<?php

namespace App\Http\Controllers;

use App\Categories;
use DB;
use Datatables;
use Illuminate\Http\Request;

class CategoriesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

    }
    public function categorieslist()
    {
        return view('categories.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('categories.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required'
        ], [
            'name.required' => 'App Name is required'
        ]);
        Categories::create($request->all());
        return redirect('categorieslist')
            ->with('success','App created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function show(Categories $categories)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $categories = \App\Categories::find($id);
        return view('categories.edit',compact('categories','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required'
        ], [
            'name.required' => 'App Name is required'
        ]);
        $categories= \App\Categories::find($id);
        $categories->name=$request->get('name');
        $categories->shortname=$request->get('shortname');
        $categories->save();
       // return redirect('categories');
        return redirect('categorieslist')
            ->with('success','App updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Categories  $categories
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $categories = \App\Categories::find($id)->delete();
        //$categories->delete();
        return redirect('categorieslist')->with('success','App has been deleted');
    }
}
