<?php

namespace App\Http\Controllers;

use App\Http\Requests;
use App\User;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendMailable;
class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $apps = DB::table("tickets")
            ->join('categories', 'tickets.category_id', '=', 'categories.id')
            ->select('tickets.category_id','categories.name', DB::raw('COUNT(tickets.category_id) as totalrow'))
            ->groupBy('tickets.category_id')
           ->get();


        $subcategories = DB::table('tickets')
            ->join('subcategories', 'tickets.sub_category_id', '=', 'subcategories.id')
            ->select('tickets.sub_category_id','subcategories.name', DB::raw('COUNT(tickets.sub_category_id) as count'))
            ->groupBy('sub_category_id')
            ->get();

        $domain = DB::table('tickets')
            ->select('domain_name', DB::raw('COUNT(tickets.domain_name) as count'))
            ->groupBy('domain_name')->get();

        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        $statuses = DB::table('statuses')->whereNull('deleted_at')->pluck("name","id");
        return view('home',compact('apps','subcategories','domain','category','statuses'));

    }



    public function mails()
    {
        $name = 'jaydeep';
        Mail::to('jaydeep@simprosys.net')->send(new SendMailable($name));

        return 'Email was sent';

    }

    public function mail()
    {

        $from = 'Simprosys Infomedia <support@simprosys.com>';
        $to = 'Support System <jaydeep@simprosys.net>';
        $cc = 'Support System <jaydeep@simprosys.net>';
        $bcc = 'Support System <jaydeep@simprosys.net>';
        $subject = 'Support Ticketing System';
        $message = '<b>Support Ticketing System</b> .';

        $data = array('from' => $from, 'to' => $to, 'cc' => $cc, 'cc' => $cc, 'bcc' => $bcc, 'subject' => $subject, 'message' => $message);
        Helpers::mail($data);

    }

}
