<?php

namespace App\Http\Controllers;

use App\Priorities;
use DB;
use Datatables;
use Illuminate\Http\Request;

class PrioritiesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {

    }
    public function prioritylist()
    {
        return view('priorities.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('priorities.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required|unique:priorities|string|max:10',
        ], [
            'name.required' => 'priority is required',
        ]);
        if($request->default_set == 1)
        {
            $affected = DB::table('priorities')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        Priorities::create($request->all());
        return redirect('prioritylist')->with('success','Priority created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function show(Priorities $priorities)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $priorities = \App\Priorities::find($id);
        return view('priorities.edit',compact('priorities','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required|string|max:10',
        ], [
            'name.required' => 'App Name is required',
        ]);
        if($request->default_set == 1)
        {
            $affected = DB::table('priorities')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        $priorities= \App\Priorities::find($id);
        $priorities->name=$request->get('name');
        $priorities->color=$request->get('color');
        $priorities->default_set=$request->get('default_set');
        $priorities->save();
        return redirect('prioritylist')->with('success','Priority updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Priorities  $priorities
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $priorities = \App\Priorities::find($id);
        if($priorities->default_set == 0)
        {
            //$priorities->delete();
            $priorities = \App\Priorities::find($id)->delete();
            return redirect('prioritylist')->with('success','Priority has been deleted');
        }
        else{
            return redirect('prioritylist')->with('errors','Do not delete Default Priority !');
        }


    }
}
