<?php

namespace App\Http\Controllers;

use App\Statuses;
use DB;
use Datatables;
use Illuminate\Http\Request;

class StatusesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

    }

    public function statuslist()
    {
        return view('statuses.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('statuses.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required',
        ], [
            'name.required' => 'Status Name is required',
        ]);
        if($request->default_set == 1)
        {
            $affected = DB::table('statuses')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        Statuses::create($request->all());
        return redirect('statuslist')->with('success','Status created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Statuses  $statuses
     * @return \Illuminate\Http\Response
     */
    public function show(Statuses $statuses)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Statuses  $statuses
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $statuses = \App\Statuses::find($id);
        return view('statuses.edit',compact('statuses','id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Statuses  $statuses
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required',
        ], [
            'name.required' => 'Status Name is required',
        ]);

        if($request->default_set == 1)
        {
            $affected = DB::table('statuses')->where('default_set', '=', 1)->update(array('default_set' => 0));
        }

        $statuses= \App\Statuses::find($id);
        $statuses->name=$request->get('name');
        $statuses->color=$request->get('color');
        $statuses->default_set=$request->get('default_set');
        $statuses->save();
        return redirect('statuslist')->with('success','Status updated successfully');
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Statuses  $statuses
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $statuses = \App\Statuses::find($id);
        if($statuses->default_set == 0)
        {
            //$statuses->delete();
            $statuses = \App\Statuses::find($id)->delete();
            return redirect('statuslist')->with('success','Status has been deleted');
        }
        else{
            return redirect('statuslist')->with('errors','Do not delete Default Status !');
        }

    }
}
