<?php

namespace App\Http\Controllers;

use App\Subcategories;
use DB;
use Datatables;
use Illuminate\Http\Request;

class SubcategoriesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

    }

    public function subcategorieslist()
    {
        $category = DB::table('categories')->pluck("name","id");
        return view('subcategories.index',compact('category'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        /* get all the category from Database*/
      $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        //$category = DB::table('subcategories')->join('categories', 'categories.id', '=', 'subcategories.category_id')->select('categories.*')->whereNull('subcategories.deleted_at')->whereNull('categories.deleted_at')->pluck("name","id");

        return view('subcategories.create',compact('category'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate([
            'name' => 'required',
            'category_id' => 'required|not_in:0',
        ], [
            'name.required' => 'Category Name is required',
            'category_id.required' => 'App is required',
        ]);
        Subcategories::create($request->all());
        return redirect('subcategorieslist')
            ->with('success','Category created successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Subcategories  $subcategories
     * @return \Illuminate\Http\Response
     */
    public function show(Subcategories $subcategories)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Subcategories  $subcategories
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $subcategories = \App\Subcategories::find($id);
        $category = DB::table('categories')->whereNull('deleted_at')->pluck("name","id");
        //$table->whereNull('deleted_at');
        return view('subcategories.edit',compact('subcategories','id', 'category'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Subcategories  $subcategories
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate([
            'name' => 'required',
            'category_id' => 'required|not_in:0',
        ], [
            'name.required' => 'Category Name is required',
            'category_id.required' => 'App is required',
        ]);
        $subcategories= \App\Subcategories::find($id);
        $subcategories->category_id=$request->get('category_id');
        $subcategories->name=$request->get('name');
        //dd($subcategories);


       $subcategories->save();
        // return redirect('categories');
        return redirect('subcategorieslist')
            ->with('success','Category updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Subcategories  $subcategories
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $subcategories = \App\Subcategories::find($id)->delete();
       // $subcategories->delete();
        return redirect('subcategorieslist')->with('success','Category has been deleted');
    }
}
