<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendMailable extends Mailable
{
    use Queueable, SerializesModels;
    public $data;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data)
    {
       $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        //return $this->view('name');
        //dd($this->data['subject']);
        return $this->view('tickets.ticketsmail')
            ->with([
                'ticketSubject' => $this->data['subject'],
                'ticketContent' => $this->data['content'],
                'ticketEmail' => $this->data['email'],
            ]);
    }
}
