<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Auth;
use DB;
use \Illuminate\Support\Facades\View;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        View::composer('*', function($view) {
          
             if (Auth::check()) {
                $permission_ids = DB::table('roles')->select('permission_ids')->where('id', Auth::user()->role_id)->get();
                View::share('permission_ids', $permission_ids);
                
                $all_assign_app = json_decode(Auth::user()->category_ids);
                $tickets = DB::table('tickets')->whereNull('deleted_at')->whereIn("tickets.status_id", [1,3,4,5,6])
                    ->whereIn("category_id", array_flatten($all_assign_app))
                    ->get()->count();
                View::share('activetickets', $tickets);

                $ticketscomplete = DB::table('tickets')->whereNull('deleted_at')->where("tickets.status_id", "=", 2)
                    ->whereIn("category_id", array_flatten($all_assign_app))
                    ->get()->count();
                View::share('completetickets', $ticketscomplete);

                $newtickets = DB::table('tickets')->whereNull('deleted_at')->where("ticketable_type", "=", 0)
                    ->whereIn("category_id", array_flatten($all_assign_app))
                    ->get()->count();
                View::share('newtickets', $newtickets);

                $opentickets = DB::table('tickets')->whereNull('deleted_at')->where("ticketable_type", "=", 1)
                    ->whereIn("category_id", array_flatten($all_assign_app))
                    ->get()->count();
                View::share('opentickets', $opentickets);
            }
        });


        $domain_name = env('DOMAIN_NAME');
        $usertotalactivetickets = DB::table('tickets')->whereNull('deleted_at')->whereIn("tickets.status_id", [1,3])->where("tickets.domain_name", "=", $domain_name)->get()->count();
        View::share('usertotalactivetickets', $usertotalactivetickets);

        $usertotalcompletetickets = DB::table('tickets')->whereNull('deleted_at')->whereIn("tickets.status_id", [2])->where("tickets.domain_name", "=", $domain_name)->get()->count();
        View::share('usertotalcompletetickets', $usertotalcompletetickets);
    
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
