 $(document).ready(function() {

    $('select[name="category_id"]').on('change', function(){
        var categoryId = $(this).val();
        if(categoryId) {
            $.ajax({
                url: APP_URL+'/sub_category/get/'+categoryId,
                type:"GET",
                dataType:"json",
                beforeSend: function(){
                    $('#loader').css("visibility", "visible");
                },

                success:function(data) {

                    $('select[name="sub_category_id"]').empty();

                    $.each(data, function(key, value){

                        $('select[name="sub_category_id"]').append('<option value="'+ key +'">' + value + '</option>');

                    });
                },
                complete: function(){
                    $('#loader').css("visibility", "hidden");
                }
            });
        } else {
            $('select[name="sub_category_id"]').empty();
        }

    });


     //Form Validation for App's

     $("#formapp").validate({
         ignore: [],
         rules : {
             name : {
                 required : true
             },
             email : {
                 required: true,
                 email:true
             }
         },
         messages: {
             name: "The subject field is required.",
             email: "Enter you email"
         },
         submitHandler: function(form) {
             form.submit();
         }
     });
});





