@extends('layouts.layout')
@section('title', 'Create Canned response')
@section('content')

    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-plus"></i>
                <h3>Create New Canned response</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <div class="span6">
                <form method="POST" action="{{ route('canned-response.store') }}" accept-charset="UTF-8" class="form-horizontal" id="formapp">
                    <fieldset>
                        @csrf

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Apps:</label>
                            <div class="controls">
                                <select name="category_ids[]" id="multiple-checkboxes" class="span6" multiple="multiple">
                                    @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}"> {{ $value }}</option>
                                    @endforeach
                                </select>
                                
                                  <span class="text-danger apperror"></span>
                                
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Title:</label>
                            <div class="controls">
                                <input class="span6" name="title" type="text" id="title" placeholder="Canned response Title
">@if ($errors->has('title'))
                                    <span class="text-danger">{{ $errors->first('title') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                             <label class="control-label asterisk" for="firstname">Description:</label>
                            <div class="controls">
                                <textarea class="ckeditor" name="content" cols="30" id="content" placeholder="Describe your Canned response here in details"></textarea>
                                <span class="text-danger contenterror"></span>
                            </div>
                        </div>


                        <br />
                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Submit">
                            <a href="{{ url('canned-response') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
                </div>
                <div class="span2">&nbsp;</div>
<div class="span3">
	<div class="control-group">
		<div class="controls">
			<h2>Valid Shortcodes</h2>
			<p>This is a list shortcodes that have been organized by content areas where they can be used:</p>  
			<h3>To :</h3>
			<table>
			<tr><td>[NAME]</td></tr>
			<tr><td>[EMAIL]</td></tr>
			<tr><td>[TICKET_NUMBER]</td></tr>
			<tr><td>[TICKET_SUBJECT]</td></tr>
			<tr><td>[TICKET_DATE]</td></tr>
			<tr><td>[TICKET_STATUS]</td></tr>
			</table>
		</div>
	</div>
</div> 
                
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
    
 
  <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/js/bootstrap-multiselect.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-multiselect/0.9.13/css/bootstrap-multiselect.css">
      <link rel="stylesheet" type="text/css" href="{{ asset('css/custom.css') }}" >


    <script src="//ajax.microsoft.com/ajax/jquery.validate/1.7/jquery.validate.min.js"></script>
    <script src="//openconcept.ca/sites/all/libraries/ckeditor/ckeditor.js"></script>
    <script type="text/javascript">
    $(document).ready(function() {
        $('#multiple-checkboxes').multiselect({
            includeSelectAllOption: true
        });

        $("#formapp").validate({
            rules: {
                content: {
                    required: true,
                    minlength: 10
                },
                title: {
                    required: true
                },
                "category_ids[]": {
                    required: true
                }
            },
            messages: {
                title:{
                    required: "Canned response Title is required"
                },
                content: {
                required: "Enter Describe your Canned response here in details",
                    minlength: "Minimum password length is 10"
                },
                "category_ids[]":
                {
                    required: " App is required"
                }
            },
            errorPlacement: function(error, element) {
                if (element.attr("id") == "content") {
                    //element.parent('div').prev().append(error[0]);
                    $(".contenterror").append(error[0]);
                } 
                else if(element.attr("id") == "multiple-checkboxes")
                {
                    $(".apperror").append(error[0]);
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function(form) {
                form.submit();
            }
        });


        CKEDITOR.on('instanceReady', function () {
        $.each(CKEDITOR.instances, function (instance) {
            CKEDITOR.instances[instance].document.on("keyup", CK_jQ);
            CKEDITOR.instances[instance].document.on("paste", CK_jQ);
            CKEDITOR.instances[instance].document.on("keypress", CK_jQ);
            CKEDITOR.instances[instance].document.on("blur", CK_jQ);
            CKEDITOR.instances[instance].document.on("change", CK_jQ);
        });
        });
        
        function CK_jQ() {
        for (instance in CKEDITOR.instances) {
            CKEDITOR.instances[instance].updateElement();
        }
        }
        
        CKEDITOR.config.toolbar = [
            ['Bold','Italic','Underline','StrikeThrough','-','Undo','Redo','-','Cut','Copy','Paste','Find','Replace','-','Outdent','Indent','-','Print']

        ] ;

    });
    </script>
@endsection
