@extends('layouts.layout')
@section('title', 'Edit Configuration')
@section('content')
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit Configuration : {{ $configuration->name }}</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('configuration.update',$configuration->id) }}" accept-charset="UTF-8" class="form-horizontal">
                    @csrf
                    @method('PUT')
                    <fieldset>

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" value="{{ $configuration->name }}" placeholder="configuration Name
">@if ($errors->has('name'))
                                    <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="config_val">Value:</label>
                            <div class="controls">
                                <input class="span3" name="config_val" type="text" id="config_val" value="{{ $configuration->config_val }}" placeholder="configuration Value
">@if ($errors->has('config_val'))
                                    <span class="text-danger">{{ $errors->first('config_val') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->


                        <br />


                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="{{ url('configuration') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
@endsection