@extends('layouts.layout')
@section('title', 'Configuration')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif

            <h2>Configuration Settings</h2>
        <br/>
    <div class="widget">
        <div class="widget-header"> <i class="icon-th-list"></i>
            <h3>Configuration Settings</h3>
        </div>
        <!-- /widget-header -->
        <div class="widget-content widget-table action-table">
            <table class="table table-condensed table-stripe ddt-responsive" id="table">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Value</th>
                    <th>Last Updated</th>
                    <th class="td-actions">Actions</th>
                </tr>
                </thead>
            </table>
        </div>
        <!-- /widget-content -->
    </div>
    <!-- /widget -->
    </div>
    <script>
        $(function() {
            $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'configuration']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'config_val', name: 'config_val' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
        });
    </script>

@endsection
