@extends('layouts.layout')
@section('title', 'Dashboard')
@section('content')
    <div class="row">
        <div class="span12">
            <div class="widget widget-nopad">
                <div class="widget-header"> <i class="icon-list-alt"></i>
                    <h3> Support Ticketing System Stats</h3>
                </div>
                <!-- /widget-header -->
                <div class="widget-content">
                    <div class="widget big-stats-container">
                        <div class="widget-content">
                            <div id="big_stats" class="cf">
                                
                                <a href="{{ url('tickets?status=0') }}" class="stat" title="New"><h2>New</h2><span class="value"><i class="icon-file"></i> {{$newtickets}}</span> </a>

                                <a href="{{ url('tickets?status=1') }}" class="stat" title="Open"><h2>Open</h2><span class="value"><i class="icon-folder-open"></i> {{$opentickets}}</span> </a>

                                <a href="{{ url('complete') }}" class="stat" title="Completed tickets"><h2>Completed tickets</h2><span class="value"><i class="icon-folder-close"></i> {{$completetickets}}</span> </a>
                                <!-- .stat -->
                                
                                <a href="{{ url('tickets') }}" class="stat" title="Total tickets"><h2>Total tickets</h2><span class="value"><i class="icon-anchor"></i> {{$activetickets + $completetickets}}</span> </a>
                                <!-- .stat -->

                            </div>
                        </div>
                        <!-- /widget-content -->

                    </div>
                </div>
            </div>
            <!-- /widget -->
        </div>
        <!-- /span6 -->
    </div>
    <!-- /row -->
    <div class="row">
        <div class="span12">
            <div class="widget widget-table action-table">
                <div class="widget-header"> <i class="icon-th-list"></i>
                    <h3> Recent Tickets</h3>
                    <select id="statusFilter" name="search_group_filter" class="pull-right" style="margin: 7px;">
                        <option value="0">All Apps</option>
                        @foreach ($category as $cat => $value)
                            <option value="{{ $cat }}"> {{ $value }}</option>
                        @endforeach
                    </select>
                    <select id="customstatusFilter" name="search_group_filter" class="pull-right" style="margin: 7px;">
                        <option value="0">All Status</option>
                        @foreach ($statuses as $status => $value)
                            <option value="{{ $status }}"> {{ $value }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- /widget-header -->
                <div class="widget-content">
                    <table class="table table-striped table-bordered" id="table">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Ticket</th>
                            <th>Category</th>
                            <th>Priority</th>
                            <th>Last Updated</th>
                            <th>Status</th>
                        </tr>
                        </thead>

                    </table>
                </div>

                <div class="widget-header">
                    <div class="pull-right">
                        <div class="btn-group">
                            <h3><a href="{{ url('tickets') }}">View more</a></h3>
                        </div>
                    </div>
                </div>
                <!-- /widget-content -->
            </div>
        </div>
    </div>
    <script>
        $(function() {
            var dtListtickets = $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0,
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'subject', name: 'subject' },
                    { data: 'subname', name: 'subname' },
                    { data: 'pname', name: 'pname' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'sname', name: 'sname' }

                ],
                "aaSorting": [],
                "paging":   false,
                "bInfo": false,
                "bFilter": false,
                "ordering": false
            });

                     $("select[name='search_group_filter']").on( 'change', function (event) {
                        event.preventDefault();
                        var appFilter = $("#statusFilter option:selected").val();
                         var customstatusFilter = $("#customstatusFilter option:selected").val();
                        //alert(customstatusFilter + " - " + appFilter);
                        
                        if(appFilter != 0 && customstatusFilter != 0)
                        {
                                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&pstatus=' + customstatusFilter;
                                dtListtickets.ajax.url(new_url).load();
                        }
                        else if(appFilter != 0)
                        {

                                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter;
                                dtListtickets.ajax.url(new_url).load();
                        }
                        else if(customstatusFilter != 0)
                        {
                            var new_url = '{{ url('loaddata') }}?action=subfiltertickets&pstatus=' + customstatusFilter;
                            dtListtickets.ajax.url(new_url).load();
                        }
                        else
                        {
                            var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0;
                            dtListtickets.ajax.url(new_url).load();
                        }
                    } );
        });
    </script>
@endsection
