<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>@yield('title') - Support Ticketing System</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/bootstrap.min.css') }}" >
    <link rel="stylesheet" type="text/css" href="{{ asset('css/bootstrap-responsive.min.css') }}" >
    <link href="//fonts.googleapis.com/css?family=Open+Sans:400italic,600italic,400,600"
          rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="{{ asset('css/font-awesome.css') }}" >
    <link rel="stylesheet" type="text/css" href="{{ asset('css/style.css') }}" >
    <link rel="stylesheet" type="text/css" href="{{ asset('css/pages/dashboard.css') }}" >
    <link rel="stylesheet" type="text/css" href="{{ asset('css/custom.css?version=0123456') }}" >
    <link  href="//cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css" rel="stylesheet">
    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
    <script src="{{asset('js/jquery-1.7.2.min.js')}}"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.17.0/jquery.validate.min.js"></script>
    <script src="//cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    <script src="{{asset('js/excanvas.min.js')}}"></script>
    <script src="{{asset('js/chart.min.js')}}" type="text/javascript"></script>
    <script src="{{asset('js/bootstrap.js')}}"></script>
    <script src="{{asset('js/base.js')}}"></script>

</head>
<body>
<div class="navbar navbar-fixed-top">
    <div class="navbar-inner">
        <div class="container"> <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse"><span
                        class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span> </a><a class="brand" href="{{ route('home') }}">Support Ticketing System </a>
            <div class="nav-collapse">
                <ul class="nav pull-right">
                    @guest
                    <li class="dropdown"><a href="#" data-toggle="dropdown">Domain Name : {{env('DOMAIN_NAME')}}</a>
                    </li>
                    <li><a class="dropdown" href="{{ route('login') }}">{{ __('Login') }}</a></li>
                    @else
                    <li class="dropdown"><a href="#" class="dropdown-toggle" data-toggle="dropdown"><i
                                    class="icon-user"></i> {{ Auth::user()->name }} <b class="caret"></b></a>
                        <ul class="dropdown-menu">
                            <li><a  href="{{ route('logout') }}"
                                   onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                    {{ __('Logout') }}
                                </a>

                                <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                    @csrf
                                </form></li>
                        </ul>
                    </li>
                    @endguest
                </ul>
            </div>
            <!--/.nav-collapse -->
        </div>
        <!-- /container -->
    </div>
    <!-- /navbar-inner -->
</div>
<!-- /navbar -->
<div class="subnavbar">
    <div class="subnavbar-inner">
        <div class="container">
            <ul class="mainnav">
                @guest
                <li class="{{ Request::is('useractivetickets') ? 'active' : '' }}"><a href="{{ url('useractivetickets') }}"><i class="icon-thumbs-up-alt"></i><span>Active Tickets <span class="badge">{{$usertotalactivetickets}}</span></span></a> </li>
                <li class="{{ Request::is('usercompletetickets') ? 'active' : '' }}"><a href="{{ url('usercompletetickets') }}"><i class="icon-folder-close"></i><span>Completed Tickets <span class="badge">{{$usertotalcompletetickets}}</span></span></a> </li>
                @else
                <li class="{{ Request::is('home') ? 'active' : '' }}"><a href="{{ url('home') }}"><i class="icon-dashboard"></i><span>Dashboard</span> </a> </li>
                <li class="{{ Request::is('tickets') ? 'active' : '' }}"><a href="{{ url('tickets') }}"><i class="icon-thumbs-up-alt"></i><span>Active Tickets <span class="badge">{{ $activetickets }}</span></span> </a> </li>
                <li class="{{ Request::is('complete') ? 'active' : '' }}"><a href="{{ url('complete') }}"><i class="icon-folder-close"></i><span>Completed Tickets <span class="badge">{{$completetickets}}</span></span> </a> </li>
                @if(Auth::user())
                    @if(str_contains($permission_ids[0]->permission_ids, 1))
                <li class="{{ Request::is('users') ? 'active' : '' }}"><a href="{{ url('users') }}"><i class="icon-user"></i><span>Users</span> </a> </li>
                    @endif
                @endif
                    @if(Auth::user())
                        @if(str_contains($permission_ids[0]->permission_ids, 2))
               <li class="dropdown {{ Request::is('prioritylist') || Request::is('statuslist') || Request::is('canned-response') || Request::is('ticket-email-templates') || Request::is('suggestions') || Request::is('suggestiontrackings') || Request::is('categorieslist') || Request::is('configuration') || Request::is('roles') || Request::is('subcategorieslist') ? 'active' : '' }}"><a href="javascript:;" class="dropdown-toggle" data-toggle="dropdown"> <i class="icon-wrench"></i><span>Settings</span> <b class="caret"></b></a>
                <ul class="dropdown-menu">
                    <li {{ Request::is('prioritylist') ? ' class=active' : '' }}><a href="{{ url('prioritylist') }}">Priorities</a></li>
                    <li {{ Request::is('categorieslist') ? ' class=active' : '' }}><a href="{{ url('categorieslist') }}">App's</a></li>
                    <li {{ Request::is('subcategorieslist') ? ' class=active' : '' }}><a href="{{ url('subcategorieslist') }}">Categories</a></li>
                    <li {{ Request::is('statuslist') ? ' class=active' : '' }}><a href="{{ url('statuslist') }}">Status</a></li>
                    <li {{ Request::is('canned-response') ? ' class=active' : '' }}><a href="{{ url('canned-response') }}">Canned response</a></li>
                    <li {{ Request::is('ticket-email-templates') ? ' class=active' : '' }}><a href="{{ url('ticket-email-templates') }}">Email Templates</a></li>
                    <li {{ Request::is('suggestions') ? ' class=active' : '' }}><a href="{{ url('suggestions') }}">Suggestions</a></li>
                    <li {{ Request::is('suggestiontrackings') ? ' class=active' : '' }}><a href="{{ url('suggestiontrackings') }}">Suggestions Tracking</a></li>
                    <li {{ Request::is('roles') ? ' class=active' : '' }}><a href="{{ url('roles') }}">Roles</a></li>
                    <li {{ Request::is('configuration') ? ' class=active' : '' }}><a href="{{ url('configuration') }}">configuration</a></li>
                </ul>
                </li>
                        @endif
                    @endif
                @endguest
            </ul>
        </div>
        <!-- /container -->
    </div>
    <!-- /subnavbar-inner -->
</div>
<!-- /subnavbar -->
<div class="main">
    <div class="main-inner">
        <div class="container">
    @yield('content')
        </div>
        <!-- /container -->
    </div>
    <!-- /main-inner -->
</div>
<!-- /main -->

<!-- /extra -->
<div class="footer">
    <div class="footer-inner">
        <div class="container">
            <div class="row">
                <div class="span12"> &copy; 2018 <a href="#">Support Ticketing System</a>. </div>
                <!-- /span12 -->
            </div>
            <!-- /row -->
        </div>
        <!-- /container -->
    </div>
    <!-- /footer-inner -->
</div>
<!-- /footer -->
<!-- Le javascript
================================================== -->
<!-- Placed at the end of the document so the pages load faster -->

<link href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.5.1/css/bootstrap-colorpicker.min.css" rel="stylesheet">
<script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.5.1/js/bootstrap-colorpicker.min.js"></script>

<script type="text/javascript">

    $('#simple-color-picker').colorpicker();

</script>
</body>
</html>