@extends('layouts.layout')
@section('title', 'Edit Status')
@section('content')

    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit Status : {{ $statuses->name }}</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('statuses.update',$statuses->id) }}" accept-charset="UTF-8" class="form-horizontal">
                    @csrf
                    @method('PUT')
                    <fieldset>

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" value="{{ $statuses->name }}" placeholder="Status Name
">@if ($errors->has('name'))
                                    <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label" for="firstname">Color:</label>
                            <div class="controls">
                                <input id="simple-color-picker" type="text" name="color" class="span3" value="{{ $statuses->color }}"/>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <div class="controls">


                                    @if($statuses->default_set == 1)
                                    <input type="hidden" name="default_set" value="1">
                                    @else
                                    <input type="hidden" name="default_set" value="0">
                                    @endif


                                <input type="checkbox" @if($statuses->default_set == 1) checked disabled @endif name="default_set" value="1" id="ischeck"> Default Priority</label>
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <br />


                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="{{ url('statuslist') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
@endsection