@extends('layouts.layout')
@section('title', 'Status')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif


            <h2>Status Management
                <a href="{{ route('statuses.create') }}" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Status</a>
            </h2>
        <br/>
    <div class="widget">
        <div class="widget-header"> <i class="icon-th-list"></i>
            <h3>Status Management</h3>
        </div>
        <!-- /widget-header -->
        <div class="widget-content widget-table action-table">
            <table class="table table-condensed table-stripe ddt-responsive" id="table">
                <thead>
                <tr>
                    <td>ID</td>
                    <td>Name</td>
                    <td>Default</td>
                    <th>Last Updated</th>
                    <td class="td-actions">Actions</td>
                </tr>
                </thead>
            </table>
        </div>
        <!-- /widget-content -->
    </div>
    <!-- /widget -->
    </div>
    <script>
        $(function() {
            $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{ route('loaddata.index',['action' => 'statuses']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'default_set', name: 'default_set' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
        });
    </script>
@endsection
