@extends('layouts.layout')
@section('title', 'Edit Category')
@section('content')

    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit Category : {{ $subcategories->name }}</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('subcategories.update',$subcategories->id) }}" accept-charset="UTF-8" class="form-horizontal">
                    @csrf
                    @method('PUT')
                    <fieldset>

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">App:</label>
                            <div class="controls">
                                <select name="category_id" class="span3">
                                    <option value="">Select App</option>
                                @foreach ($category as $cat => $value)
                                    <!--<option value="{{ $cat }}" {{ ($cat == $subcategories->category_id) ? 'selected="selected"' : '' }}>{{ $value }}</option>-->
                                        <option value="{{ $cat }}" @if($cat == $subcategories->category_id) selected @endif >{{ $value }}</option>

                                    @endforeach
                                </select>
                                @if ($errors->has('category_id'))
                                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" value="{{ $subcategories->name }}" placeholder="Category Name
">@if ($errors->has('name'))
                                    <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <br />


                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="{{ url('subcategorieslist') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
@endsection