@extends('layouts.layout')
@section('title', 'Create Suggestion')
@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js"></script>
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-plus"></i>
                <h3>Create New Suggestion</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('suggestions.store') }}" accept-charset="UTF-8" class="form-horizontal" id="formapp">
                    <fieldset>
                        @csrf
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">App:</label>
                            <div class="controls">
                                <select name="category_id" class="span6">
                                    <option value="">Select App</option>
                                    @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}"> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('category_id'))
                                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <div class="control-group">
                            <label class="control-label asterisk" for="suggestion">Title:</label>
                            <div class="controls">
                                <input class="span6" name="title" type="text" id="title" placeholder="Suggestion Title
">@if ($errors->has('title'))
                                    <span class="text-danger">{{ $errors->first('title') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="destination_url">Destination Url:</label>
                            <div class="controls">
                                <input class="span6" name="destination_url" type="text" id="destination_url" placeholder="Destination Url
">@if ($errors->has('destination_url'))
                                    <span class="text-danger">{{ $errors->first('destination_url') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="keywords">Keywords:</label>
                            <div class="controls">
                                <input class="span6" data-role="tagsinput" name="keywords" type="text" id="keywords" placeholder="Enter Your keywords
">@if ($errors->has('keywords'))
                                    <span class="text-danger">{{ $errors->first('keywords') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->



                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Submit">
                            <a href="{{ url('suggestions') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
<script>
    //Form Validation
    $().ready(function() {
        $("#formapp").validate({
            ignore: [],
            rules : {
                title : {
                    required : true,
                    minlength: 10
                },
                destination_url : {
                    required: true
                },
                keywords : {
                    required: true
                },
                category_id : {
                    required: true
                }
            },
            messages: {
                title: {
                    required:"The Title field is required.",
                    minlength: "Your title must be at least 10 characters long"
                },
                destination_url: "The Destination URL is required.",
                keywords: "The keywords field is required.",
                category_id: "The App field is required."
            },
            submitHandler: function(form) {
                form.submit();
            }
        });
    });
</script>
@endsection
