@extends('layouts.layout')
@section('title', 'Edit Suggestion')
@section('content')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.js"></script>
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit Suggestion : {{ $suggestions->title }}</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('suggestions.update',$suggestions->id) }}" accept-charset="UTF-8" class="form-horizontal">
                    @csrf
                    @method('PUT')
                    <fieldset>
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">App:</label>
                            <div class="controls">
                                <select name="category_id" class="span3">
                                    <option value="">Select App</option>
                                @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}" @if($cat == $suggestions->category_id) selected @endif >{{ $value }}</option>

                                    @endforeach
                                </select>
                                @if ($errors->has('category_id'))
                                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <div class="control-group">
                            <label class="control-label asterisk" for="title">Title:</label>
                            <div class="controls">
                                <input class="span6" name="title" type="text" id="title" value="{{ $suggestions->title }}" placeholder="Suggestion Title
">@if ($errors->has('title'))
                                    <span class="text-danger">{{ $errors->first('title') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="destination_url">Destination Url:</label>
                            <div class="controls">
                                <input class="span6" name="destination_url" type="text" id="destination_url" value="{{ $suggestions->destination_url }}" placeholder="Destination Url
">@if ($errors->has('destination_url'))
                                    <span class="text-danger">{{ $errors->first('destination_url') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->


                        <div class="control-group">
                            <label class="control-label asterisk" for="keywords">Keywords:</label>
                            <div class="controls">
                                <input class="span6" data-role="tagsinput" name="keywords" type="text" id="keywords" value="{{ $suggestions->keywords }}" placeholder="Enter Your keywords
">@if ($errors->has('keywords'))
                                    <span class="text-danger">{{ $errors->first('keywords') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <br />


                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="{{ url('suggestions') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
@endsection