@extends('layouts.layout')
@section('title', 'Suggestion - Trackings')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif
        <div class="span12"><h2>Suggestions Tracking</h2></div><br/><br/>
        <div class="span6">
            <div class="widget widget-table action-table">
            <div class="widget-header"> <i class="icon-th-list"></i>
              <h3>Top Keywords List</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th> No. </th>
                    <th> Keywords </th>
                    <th> View </th>
                  </tr>
                </thead>
                <tbody>
                @foreach($suggestions_top_keywords as $indexKey => $p)
                <tr>
                <td>{{ $indexKey+1 }}</td>
                  <td><span class="label label-info">{{$p->keywords}}</span></td>
                  <td><span class="label label-primary">{{$p->total_count}}</span></td>
                  </tr>
                @endforeach
                  
                  @if($suggestions_top_keywords->isEmpty())
                    <tr><td colspan="3" style="text-align: center;"><b>No Records found</b></td></tr>
                  @endif
                </tbody>
              </table>
            </div>
            <!-- /widget-content --> 
          </div>
        </div>
        <div class="span6">
            <div class="widget widget-table action-table">
            <div class="widget-header"> <i class="icon-th-list"></i>
              <h3>Top DocUrls List</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
              <table class="table table-striped table-bordered">
                <thead>
                  <tr>
                    <th> No. </th>
                    <th> Destination URL </th>
                  </tr>
                </thead>
                <tbody>
                @foreach($suggestions_top_doc_urls as $indexKey => $p)
                <tr>
                    <td>{{ $indexKey+1 }}</td>
                  <td><a href="{{$p->destination_url}}" target="_blank">{{$p->destination_url}}</a></td>
                  </tr>
                @endforeach
                  @if($suggestions_top_doc_urls->isEmpty())
                    <tr><td colspan="2" style="text-align: center;"><b>No Records found</b></td></tr>
                  @endif
                </tbody>
              </table>
            </div>
            <!-- /widget-content --> 
          </div>
        </div>

</div>
   

@endsection
