@extends('layouts.layout')

@section('content')
<div class="row">
    <div class="col-lg-3 col-md-4">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3" style="font-size: 5em;">
                        <i class="glyphicon glyphicon-th"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <h1>{{$activetickets + $completetickets}}</h1>
                        <div>Total tickets</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4">
        <div class="panel panel-danger">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3" style="font-size: 5em;">
                        <i class="glyphicon glyphicon-wrench"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <h1>{{ $activetickets }}</h1>
                        <div>Open tickets</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4">
        <div class="panel panel-success">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3" style="font-size: 5em;">
                        <i class="glyphicon glyphicon-thumbs-up"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <h1>{{$completetickets}}</h1>
                        <span>Closed tickets</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4">
        <div class="panel panel-primary">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3" style="font-size: 5em;">
                        <i class="glyphicon glyphicon-th-list"></i>
                    </div>
                    <div class="col-xs-9 text-right">
                        <h1>{{$newtickets}} / {{$opentickets}}</h1>
                        <span>New / Open</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <i class="glyphicon glyphicon-th"></i> Tickets Indicator
                <div class="pull-right">
                    <div class="btn-group">
                        <select id="statusFilter" class="pull-right">
                            <option value="0">Tickets</option>
                            <option value="1">Active</option>
                            <option value="2">Completed</option>
                        </select>

                    </div>
                </div>
            </div>
            <div class="panel-body">
                <table class="table table-condensed table-stripe ddt-responsive" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Subject</th>
                        <th>Category</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <div class="panel-footer"><a href="" >View More..</a></div>
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        Tickets share per category
                    </div>
                    <div class="panel-body">
                        <div id="catpiechart" style="width: auto; height: 350;"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        Tickets share per agent
                    </div>
                    <div class="panel-body">
                        <div id="agentspiechart" style="width: auto; height: 350;"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-4">
        <ul class="nav nav-tabs nav-justified">
            <li class="active">
                <a data-toggle="pill" href="#information-panel-apps">
                    <i class="glyphicon glyphicon-briefcase"></i>
                    <small>App's</small>
                </a>
            </li>
            <li class="">
                <a data-toggle="pill" href="#information-panel-categories">
                    <i class="glyphicon glyphicon-folder-close"></i>
                    <small>Categories</small>
                </a>
            </li>
            <li class="">
                <a data-toggle="pill" href="#information-panel-users">
                    <i class="glyphicon glyphicon-info-sign"></i>
                    <small>Domain</small>
                </a>
            </li>
        </ul>
        <br>
        <div class="tab-content">
            <div id="information-panel-apps" class="list-group tab-pane fade in active">
                <a href="#" class="list-group-item disabled">
                            <span>App's
                                <span class="badge">Total</span>
                            </span>
                    <span class="pull-right text-muted small">
                                <em>
                                    New /
                                     Open
                                </em>
                            </span>
                </a>
                @foreach ($apps as $app)
                <a href="#" class="list-group-item">
                        <span style="color: #0014f4">
                            {{$app->name}} <span class="badge">{{$app->totalrow}}</span>
                        </span>
                    <span class="pull-right text-muted small">
                            <em>
                                0 /
                                 0
                            </em>
                        </span>
                </a>
                @endforeach
            </div>
            <div id="information-panel-categories" class="list-group tab-pane fade">
                <a href="#" class="list-group-item disabled">
                            <span>Categories
                                <span class="badge">Total</span>
                            </span>
                    <span class="pull-right text-muted small">
                                <em>
                                    New /
                                     Open
                                </em>
                            </span>
                </a>
                @foreach ($subcategories as $scat)
                <a href="#" class="list-group-item">
                        <span style="color: #0014f4">
                             {{$scat->name}} <span class="badge">{{$scat->count}}</span>
                        </span>
                    <span class="pull-right text-muted small">
                            <em>
                                0 /
                                 32
                            </em>
                        </span>
                </a>
                @endforeach
            </div>
            <div id="information-panel-users" class="list-group tab-pane fade ">
                <a href="#" class="list-group-item disabled">
                            <span>Domain Names
                                <span class="badge">Total</span>
                            </span>
                    <span class="pull-right text-muted small">
                                <em>
                                    Open /
                                    Closed
                                </em>
                            </span>
                </a>
                @foreach ($domain as $dm)
                <a href="#" class="list-group-item">
                                <span>
                                    {{$dm->domain_name}}
                                    <span class="badge">
                                        {{$dm->count}}
                                    </span>
                                </span>
                    <span class="pull-right text-muted small">
                                    <em>
                                        0 /
                                        2
                                    </em>
                                </span>
                </a>
                @endforeach
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {
        var dtListUsers = $('#table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ url('loaddata') }}?action=dashboardtickets&catid=0',
            columns: [
                { data: 'id', name: 'id' },
                { data: 'subject', name: 'subject' },
                { data: 'subname', name: 'subname' },
                { data: 'created_at', name: 'created_at' },
                { data: 'sname', name: 'sname' }

            ],
            "aaSorting": [],
            "paging":   false,
            "bInfo": false,
            "bFilter": false,
            "ordering": false
        });

        $('#statusFilter').on( 'click change', function (event) {
            event.preventDefault();
            //dataTable.draw();
            var filter_value = $(this).val();
            //alert(filter_value);
            var new_url = '{{ url('loaddata') }}?action=dashboardtickets&catid=' + filter_value;
            dtListUsers.ajax.url(new_url).load();

        } );
    });
</script>
@endsection


==========================

home.blade.php
------------------
@extends('layouts.layout')

@section('content')


<div class="row">
    <div class="span6">
        <div class="widget widget-nopad">
            <div class="widget-header"> <i class="icon-list-alt"></i>
                <h3> Support Ticketing System Stats</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <div class="widget big-stats-container">
                    <div class="widget-content">
                        <div id="big_stats" class="cf">
                            <div class="stat"><b>Total tickets</b><i class="icon-anchor"></i> <span class="value">{{$activetickets + $completetickets}}</span> </div>
                            <!-- .stat -->

                            <div class="stat"><b>Active tickets</b> <i class="icon-thumbs-up-alt"></i> <span class="value">{{ $activetickets }}</span> </div>
                            <!-- .stat -->

                            <div class="stat"><b>Completed tickets</b><i class="icon-folder-close"></i> <span class="value">{{$completetickets}}</span> </div>
                            <!-- .stat -->

                            <div class="stat"><b>New/Open</b><i class="icon-folder-open"></i> <span class="value">{{$newtickets}}/{{$opentickets}}</span> </div>
                            <!-- .stat -->
                        </div>
                    </div>
                    <!-- /widget-content -->

                </div>
            </div>
        </div>
        <!-- /widget -->

        <div class="widget widget-table action-table">
            <div class="widget-header"> <i class="icon-th-list"></i>
                <h3> Tickets Indicator</h3>
                <div class="pull-right">
                    <div class="btn-group">
                        <select id="statusFilter" class="pull-right">
                            <option value="0">Tickets</option>
                            <option value="1">Active</option>
                            <option value="2">Completed</option>
                        </select>

                    </div>
                </div>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <table class="table table-striped table-bordered" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Subject</th>
                        <th>Category</th>
                        <th>Status</th>
                    </tr>
                    </thead>

                </table>
            </div>

            <div class="widget-header">
                <div class="pull-right">
                    <div class="btn-group">
                        <h3><a href="{{ url('createdata') }}">View more</a></h3>
                    </div>
                </div>
            </div>
            <!-- /widget-content -->
        </div>
    </div>
    <!-- /span6 -->
    <div class="span6">
        <div class="widget">
            <div class="widget-header"> <i class="icon-bookmark"></i>
                <h3>Important Shortcuts</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <div class="shortcuts">
                    <a href="{{ url('createdata') }}" class="shortcut"><i class="shortcut-icon icon-thumbs-up-alt"></i><span
                                class="shortcut-label">Active Tickets</span> </a><a href="{{ url('complete') }}" class="shortcut"><i
                                class="shortcut-icon icon-folder-close"></i><span class="shortcut-label">Completed Tickets</span> </a><a href="{{ url('home') }}" class="shortcut"><i class="shortcut-icon icon-dashboard"></i> <span class="shortcut-label">Dashboard</span> </a><a href="javascript:;" class="shortcut"> <i class="shortcut-icon icon-wrench"></i><span class="shortcut-label">Settings</span> </a></div>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
        <div class="widget">
            <div class="widget-header"> <i class="icon-signal"></i>
                <h3> New/Open Tickets</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <canvas id="area-chart" class="chart-holder" height="250" width="538"> </canvas>
                <!-- /area-chart -->




            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
    <!-- /span6 -->
</div>
<!-- /row -->

<script>
    $(function() {
        var dtListUsers = $('#table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ url('loaddata') }}?action=dashboardtickets&catid=0',
            columns: [
                { data: 'id', name: 'id' },
                { data: 'subject', name: 'subject' },
                { data: 'subname', name: 'subname' },
                { data: 'sname', name: 'sname' }

            ],
            "aaSorting": [],
            "paging":   false,
            "bInfo": false,
            "bFilter": false,
            "ordering": false
        });

        $('#statusFilter').on( 'click change', function (event) {
            event.preventDefault();
            //dataTable.draw();
            var filter_value = $(this).val();
            //alert(filter_value);
            var new_url = '{{ url('loaddata') }}?action=dashboardtickets&catid=' + filter_value;
            dtListUsers.ajax.url(new_url).load();

        } );
    });
</script>

<script>


    var barChartData = {
        labels: [@foreach ($chartyear as $value)
            {{ $loop->first ? '' : ', ' }}
    '{{ $value->created_at }}'
    @endforeach],
    datasets: [
        {
            fillColor: "rgba(255, 0, 0, 0.5)",
            strokeColor: "rgba(255, 0, 0, 1)",
            data: [@foreach ($chartnew as $value)
                {{ $loop->first ? '' : ', ' }}
    '{{ $value->total }}'
    @endforeach]
    },
    {
        fillColor: "rgba(255, 185, 0, 0.5)",
            strokeColor: "rgba(255, 185, 0, 1)",
        data: [@foreach ($chartopen as $value)
        {{ $loop->first ? '' : ', ' }}
        '{{ $value->total }}'
    @endforeach]
    }
    ]

    }

    var myLine = new Chart(document.getElementById("area-chart").getContext("2d")).Bar(barChartData);


</script>
@endsection

