@extends('layouts.layout')
@section('title', 'Email Templates')
@section('content')
    <div class="row">
    @if ($message = Session::get('success'))
        <div class="alert alert-success">
            <p>{{ $message }}</p>
        </div>
    @endif
    @if ($message = Session::get('errors'))
        <div class="alert alert-danger">
            <p>{{ $message }}</p>
        </div>
    @endif

            <h2>Email Templates Management
                <a href="{{ route('ticket-email-templates.create') }}" class="btn btn-primary pull-right"><i class="icon-plus"></i> Create new Email Templates</a>
            </h2>
        <br/>
    <div class="widget">
        <div class="widget-header"> <i class="icon-th-list"></i>
            <h3>Email Templates Management</h3>
        </div>
        <!-- /widget-header -->
        <div class="widget-content widget-table action-table">
            <table class="table table-condensed table-stripe ddt-responsive" id="table">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>Subject</th>
                    <th>Last Updated</th>
                    <th class="td-actions">Actions</th>
                </tr>
                </thead>
            </table>
        </div>
        <!-- /widget-content -->
    </div>
    <!-- /widget -->
    </div>
    <script>
        $(function() {
            var dtListUsers = $('#table').DataTable({
                processing: true,
                serverSide: true,
                dom: '<"wrapper"lf<"customefilter"><t>ip>',
                ajax: '{{ route('loaddata.index',['action' => 'emailtemplates']) }}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'title', name: 'title' },
                    { data: 'updated_at', name: 'updated_at' },
                    { data: 'action', name: 'action', orderable: false, searchable: false, className: 'text-right' }
                ],
                "aaSorting": [],
                "pageLength": 25
            });
        });
    </script>
@endsection
