@extends('tickets.layout')


@section('content')



    <div class="account-container register">

        <div class="content clearfix">

            <form method="POST" action="{{ route('tickets.store') }}" class="form-horizontal" id="form">
                @csrf
                <legend>Create New Ticket</legend>

                <fieldset>


                     @if (env('SHOP_NAME') != '')
                        <input type="hidden" name="category_id" class="form-control" value="{{$cat_id}}">
                    @else
                        <div class="control-group">
                            <label class="control-label" for="firstname">App:</label>
                            <div class="controls">
                                <select name="category_id" class="span3">
                                    <option value="">Select App</option>
                                    @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}"> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('category_id'))
                                    <span class="text-danger">{{ $errors->first('category_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                    @endif
                    <div class="control-group">
                        <label class="control-label" for="firstname">Name:</label>
                        <div class="controls">
                            <input class="span6" name="username" type="text" id="username" placeholder="Name">		   @if ($errors->has('subject'))
                                <span class="text-danger">{{ $errors->first('username') }}</span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->
                    <div class="control-group">
                        <label class="control-label" for="username">Email:</label>
                        <div class="controls">
                            <input type="text" name="email" class="span6" value="admin@simprosys.net">
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->
                    
                      @if (env('SHOP_NAME') != '')
                        <div class="control-group">
                            <label class="control-label" for="firstname">Category:</label>
                            <div class="controls">
                                <select name="sub_category_id" class="span3">
                                    @foreach ($sub_category as $subcat => $value)
                                        <option value="{{ $subcat }}"> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('sub_category_id'))
                                    <span class="text-danger">{{ $errors->first('sub_category_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                    @else
                    <div class="control-group">
                        <label class="control-label" for="firstname">Category:</label>
                        <div class="controls">
                            <select name="sub_category_id" class="span3">
                                <option>Select Category</option>

                            </select>
                            @if ($errors->has('sub_category_id'))
                                <span class="text-danger">{{ $errors->first('sub_category_id') }}</span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->
                    @endif

                    <div class="control-group">
                        <label class="control-label" for="firstname">Subject:</label>
                        <div class="controls">
                            <input class="span6" name="subject" type="text" id="subject" placeholder="A brief of your issue ticket
">		   @if ($errors->has('subject'))
                                <span class="text-danger">{{ $errors->first('subject') }}</span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->

                    <div class="control-group">
                        <label class="control-label" for="firstname">Description:</label>
                        <div class="controls">
                            <textarea class="span6" name="content" cols="50" id="content" placeholder="Describe your issue here in details"></textarea>
                            @if ($errors->has('content'))
                                <span class="text-danger">{{ $errors->first('content') }}</span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->

                    <div class="control-group">
                        <label class="control-label" for="firstname">Priority:</label>
                        <div class="controls">
                            <select name="priority_id" class="span3">
                                <option value="">Select Priority</option>
                                @foreach ($priority as $prity)
                                    <option value="{{$prity->id}}" @if($prity->default_set == 1) selected @endif>{{$prity->name}}</option>
                                @endforeach
                            </select>
                            @if ($errors->has('priority_id'))
                                <span class="text-danger">{{ $errors->first('priority_id') }}</span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->

                    <div class="control-group {{ $errors->has('g-recaptcha-response') ? ' has-error' : '' }}">
                        <div class="controls">
                            <div class="g-recaptcha" data-sitekey="{{ env('CAPTCHA_SITE_KEY') }}" data-callback="correctCaptcha"></div>
                            @if ($errors->has('g-recaptcha-response'))
                                <span class="invalid-feedback" style="display: block;">
                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                    </span>
                            @endif
                        </div> <!-- /controls -->
                    </div> <!-- /control-group -->

                    <br />

                    <input type="hidden" name="domain_name" class="form-control" value="{{env('DOMAIN_NAME')}}">
                    <input type="hidden" name="ticketable_type" class="form-control" value="0">
                    <input type="hidden" name="ticketable_id" class="form-control" value="2">
                    <input type="hidden" name="status_id" class="form-control" value="{{$statuses[0]->id}}">
                    <div class="form-actions" style="display:none;">
                    <!-- <a href="{{ route('tickets.index') }}" class="btn btn-default">Back</a> -->
                        <input class="btn btn-primary" type="submit" value="Submit" id="submitbtn">
                    </div> <!-- /form-actions -->

                </fieldset>
            </form>

        </div> <!-- /content -->

    </div> <!-- /account-container -->


@endsection