@extends('layouts.layout')
@section('title', 'Tickets')

@section('content')
    <div class="row">
        <div class="span12">
            @if ($message = Session::get('success'))
                <div class="alert alert-success">
                    <p>{{ $message }}</p>
                </div>
            @endif
            <h2>
                @if($status == 1)
                    Active Tickets
                @else
                    Completed Tickets
                @endif
            </h2>
            <br/>

            <div class="widget-content">
                <table class="table table-condensed table-stripe ddt-responsive" id="table">
                    <thead>
                    <tr>
                        <th>ID</th>
                        <th>Ticket</th>
                        <th>Category</th>
                        <th>Priority</th>
                        <th>App</th>
                        <th>Last Updated</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <script>
                var categoryId = {{$status}};
                var flagstatus = {{$flagstatus}};
                $(function() {
                    var dtListUsers =  $('#table').DataTable({
                        processing: true,
                        serverSide: true,
                        //dom: '<"wrapper"f<"customefilter">lipt>',
                        dom: '<"wrapper"lf<"customefilter"><"customeprioritiyfilter"><t>ip>',
                        ajax: '{{ url('loaddata') }}?action=tickets&catid=' + categoryId + '&flagstatus=' + flagstatus,
                        columns: [
                            { data: 'id', name: 'id' },
                            { data: 'subject', name: 'subject' },
                            { data: 'subname', name: 'subname' },
                            { data: 'pname', name: 'pname' },
                            { data: 'cname', name: 'cname' },
                            { data: 'updated_at', name: 'updated_at' },
                            { data: 'sname', name: 'sname' }
                        ],
                        "aaSorting": [],
                        "pageLength": 25
                    });
                    $('.customefilter').html("<label>Filter By App: </label>    <select name='search_group_filter' id=\"statusFilter\">\n" +
                        "                            <option value=\"0\">Select App</option>\n" +
                        "                            @foreach ($category as $cat => $value)\n" +
                        "                                <option value=\"{{ $cat }}\"> {{ $value }}</option>\n" +
                        "                            @endforeach\n" +
                        "                        </select>");
                    $('.customeprioritiyfilter').html("<label>Filter By Status: </label>    <select name='search_group_filter' id=\"priorityFilter\">\n" +
                        "                            <option value=\"0\">Select Status</option>\n" +
                        "                            @foreach ($statuses as $stas => $value)\n" +
                        "                                <option value=\"{{ $stas }}\"> {{ $value }}</option>\n" +
                        "                            @endforeach\n" +
                        "                        </select>");


                    $("select[name='search_group_filter']").on( 'change', function (event) {
                        event.preventDefault();
                        var appFilter = $("#statusFilter option:selected").val();
                         var priorityFilter = $("#priorityFilter option:selected").val();
                        //alert(priorityFilter + " - " + appFilter);
                        
                        if(appFilter != 0 && priorityFilter != 0)
                        {
                                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&pstatus=' + priorityFilter + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                        else if(appFilter != 0)
                        {

                                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + appFilter + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                        else if(priorityFilter != 0)
                        {
                            var new_url = '{{ url('loaddata') }}?action=subfiltertickets&pstatus=' + priorityFilter + '&catid=' + categoryId;
                            dtListUsers.ajax.url(new_url).load();
                        }
                        else
                        {
                                var new_url = '{{ url('loaddata') }}?action=subfiltertickets&status=' + 0 + '&pstatus=' + 0 + '&catid=' + categoryId;
                                dtListUsers.ajax.url(new_url).load();
                        }
                    } );

                });


            </script>
        </div>
    </div>
@endsection