@extends('layouts.layout')
@section('title', 'Create User')
@section('content')

    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-plus"></i>
                <h3>Create New User</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">
                <div class="span6">
                <form method="POST" action="{{ route('users.store') }}" accept-charset="UTF-8" class="form-horizontal" id="formapp">
                    <fieldset>
                        @csrf
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" required placeholder="User Name
">@if ($errors->has('name'))
                                    <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Email:</label>
                            <div class="controls">
                                <input class="span3" name="email" type="text" id="email" required placeholder="User Email
">@if ($errors->has('email'))
                                    <span class="text-danger">{{ $errors->first('email') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Password:</label>
                            <div class="controls">
                                <input class="span3" id="password" type="password" name="password" required value="Support@123" placeholder="User password
"> <input type="checkbox" onclick="myFunction()">                              @if ($errors->has('password'))
                                    <span class="text-danger">{{ $errors->first('password') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Role:</label>
                            <div class="controls">
                                <select name="role_id" class="span3" required>
                                    <option value="">Select Role</option>
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->id }}" @if($role->default_set == 1) selected @endif> {{ $role->name }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('role_id'))
                                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Apps:</label>
                            <div class="controls">
                                <select name="category_ids[]" class="span3" required multiple="multiple">
                                    @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}"> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('role_id'))
                                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <br />
                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Submit">
                            <a href="{{ url('users') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
                </div>
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
    <script>
function myFunction() {
    var x = document.getElementById("password");
    if (x.type === "password") {
        x.type = "text";
    } else {
        x.type = "password";
    }
}
</script>
@endsection
