@extends('layouts.layout')
@section('title', 'Edit App')
@section('content')
    <div class="row">
        <div class="widget">
            <div class="widget-header"> <i class="icon-edit"></i>
                <h3>Edit User : {{ $users->name }}</h3>
            </div>
            <!-- /widget-header -->
            <div class="widget-content">

                <form method="POST" action="{{ route('users.update',$users->id) }}" accept-charset="UTF-8" class="form-horizontal">
                    @csrf
                    @method('PUT')
                    <fieldset>
                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Name:</label>
                            <div class="controls">
                                <input class="span3" name="name" type="text" id="name" value="{{ $users->name }}" required placeholder="User Name
">@if ($errors->has('name'))
                                    <span class="text-danger">{{ $errors->first('name') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Email:</label>
                            <div class="controls">
                                <input class="span3" name="email" type="text" id="email" value="{{ $users->email }}" required placeholder="User Email
">@if ($errors->has('email'))
                                    <span class="text-danger">{{ $errors->first('email') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Password:</label>
                            <div class="controls">
                                <input class="span3" id="password" type="password" name="password" value="{{ $users->password }}" required placeholder="User password
">                              @if ($errors->has('password'))
                                    <span class="text-danger">{{ $errors->first('password') }}</span>
                                @endif                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Role:</label>
                            <div class="controls">
                                <select name="role_id" class="span3" required>
                                    <option value="">Select Role</option>
                                    @foreach ($roles as $role => $value)
                                        <option value="{{ $role }}" @if($role == $users->role_id) selected @endif> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('role_id'))
                                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->

                        <div class="control-group">
                            <label class="control-label asterisk" for="firstname">Apps:</label>
                            <div class="controls">
                                <select name="category_ids[]" class="span3" required multiple="multiple">
                                    @foreach ($category as $cat => $value)
                                        <option value="{{ $cat }}" @if (str_contains($users->category_ids, $cat)) selected @endif> {{ $value }}</option>
                                    @endforeach
                                </select>
                                @if ($errors->has('role_id'))
                                    <span class="text-danger">{{ $errors->first('role_id') }}</span>
                                @endif
                            </div> <!-- /controls -->
                        </div> <!-- /control-group -->
                        <br />

                        <div class="form-actions">
                            <input class="btn btn-primary" type="submit" value="Update">
                            <a href="{{ url('users') }}" class="btn btn-default">Back</a>
                        </div> <!-- /form-actions -->
                    </fieldset>
                </form>
                <!-- /shortcuts -->
            </div>
            <!-- /widget-content -->
        </div>
        <!-- /widget -->
    </div>
    <script>
        $(function() {
        $('.checked_all').on('change', function() {
            $('.checkbox').prop('checked', $(this).prop("checked"));
        });
        //deselect "checked all", if one of the listed checkbox product is unchecked amd select "checked all" if all of the listed checkbox product is checked
        $('.checkbox').change(function(){ //".checkbox" change
            if($('.checkbox:checked').length == $('.checkbox').length){
                $('.checked_all').prop('checked',true);
            }else{
                $('.checked_all').prop('checked',false);
            }
        });
        });
    </script>
@endsection